/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.dora;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.file.dora.WorkerLocationPolicy;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.status.ResourceExhaustedException;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.WorkerNetAddress;
import java.util.ArrayList;
import java.util.List;

public class LocalWorkerPolicy
implements WorkerLocationPolicy {
    private final AlluxioConfiguration mConf;

    public LocalWorkerPolicy(AlluxioConfiguration conf) {
        this.mConf = conf;
    }

    @Override
    public List<BlockWorkerInfo> getPreferredWorkers(List<BlockWorkerInfo> blockWorkerInfos, String fileId, int count) throws ResourceExhaustedException {
        String userHostname = NetworkAddressUtils.getClientHostName(this.mConf);
        ArrayList<BlockWorkerInfo> results = new ArrayList<BlockWorkerInfo>();
        for (BlockWorkerInfo worker : blockWorkerInfos) {
            WorkerNetAddress workerAddr = worker.getNetAddress();
            if (workerAddr == null || !userHostname.equals(workerAddr.getHost())) continue;
            results.add(worker);
            if (results.size() < count) continue;
            break;
        }
        if (results.size() < count) {
            throw new ResourceExhaustedException(String.format("Failed to find a local worker for client hostname %s", userHostname));
        }
        return results;
    }
}

