/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.etcd.jetcd.impl;

import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.protobuf.ByteString;
import alluxio.shaded.client.io.etcd.jetcd.Auth;
import alluxio.shaded.client.io.etcd.jetcd.ByteSequence;
import alluxio.shaded.client.io.etcd.jetcd.api.AuthDisableRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.AuthEnableRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleAddRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleDeleteRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleGetRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleGrantPermissionRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleListRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleRevokePermissionRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.AuthUserAddRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.AuthUserChangePasswordRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.AuthUserDeleteRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.AuthUserGetRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.AuthUserGrantRoleRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.AuthUserListRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.AuthUserRevokeRoleRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.Permission;
import alluxio.shaded.client.io.etcd.jetcd.api.VertxAuthGrpc;
import alluxio.shaded.client.io.etcd.jetcd.auth.AuthDisableResponse;
import alluxio.shaded.client.io.etcd.jetcd.auth.AuthEnableResponse;
import alluxio.shaded.client.io.etcd.jetcd.auth.AuthRoleAddResponse;
import alluxio.shaded.client.io.etcd.jetcd.auth.AuthRoleDeleteResponse;
import alluxio.shaded.client.io.etcd.jetcd.auth.AuthRoleGetResponse;
import alluxio.shaded.client.io.etcd.jetcd.auth.AuthRoleGrantPermissionResponse;
import alluxio.shaded.client.io.etcd.jetcd.auth.AuthRoleListResponse;
import alluxio.shaded.client.io.etcd.jetcd.auth.AuthRoleRevokePermissionResponse;
import alluxio.shaded.client.io.etcd.jetcd.auth.AuthUserAddResponse;
import alluxio.shaded.client.io.etcd.jetcd.auth.AuthUserChangePasswordResponse;
import alluxio.shaded.client.io.etcd.jetcd.auth.AuthUserDeleteResponse;
import alluxio.shaded.client.io.etcd.jetcd.auth.AuthUserGetResponse;
import alluxio.shaded.client.io.etcd.jetcd.auth.AuthUserGrantRoleResponse;
import alluxio.shaded.client.io.etcd.jetcd.auth.AuthUserListResponse;
import alluxio.shaded.client.io.etcd.jetcd.auth.AuthUserRevokeRoleResponse;
import alluxio.shaded.client.io.etcd.jetcd.auth.Permission;
import alluxio.shaded.client.io.etcd.jetcd.impl.ClientConnectionManager;
import alluxio.shaded.client.io.etcd.jetcd.impl.Impl;
import java.util.concurrent.CompletableFuture;

final class AuthImpl
extends Impl
implements Auth {
    private final VertxAuthGrpc.AuthVertxStub stub;

    AuthImpl(ClientConnectionManager connectionManager) {
        super(connectionManager);
        this.stub = connectionManager.newStub(VertxAuthGrpc::newVertxStub);
    }

    @Override
    public CompletableFuture<AuthEnableResponse> authEnable() {
        AuthEnableRequest enableRequest = AuthEnableRequest.getDefaultInstance();
        return this.completable(this.stub.authEnable(enableRequest), AuthEnableResponse::new);
    }

    @Override
    public CompletableFuture<AuthDisableResponse> authDisable() {
        AuthDisableRequest disableRequest = AuthDisableRequest.getDefaultInstance();
        return this.completable(this.stub.authDisable(disableRequest), AuthDisableResponse::new);
    }

    @Override
    public CompletableFuture<AuthUserAddResponse> userAdd(ByteSequence user, ByteSequence password) {
        Preconditions.checkNotNull(user, "user can't be null");
        Preconditions.checkNotNull(password, "password can't be null");
        AuthUserAddRequest addRequest = AuthUserAddRequest.newBuilder().setNameBytes(ByteString.copyFrom(user.getBytes())).setPasswordBytes(ByteString.copyFrom(password.getBytes())).build();
        return this.completable(this.stub.userAdd(addRequest), AuthUserAddResponse::new);
    }

    @Override
    public CompletableFuture<AuthUserDeleteResponse> userDelete(ByteSequence user) {
        Preconditions.checkNotNull(user, "user can't be null");
        AuthUserDeleteRequest deleteRequest = AuthUserDeleteRequest.newBuilder().setNameBytes(ByteString.copyFrom(user.getBytes())).build();
        return this.completable(this.stub.userDelete(deleteRequest), AuthUserDeleteResponse::new);
    }

    @Override
    public CompletableFuture<AuthUserChangePasswordResponse> userChangePassword(ByteSequence user, ByteSequence password) {
        Preconditions.checkNotNull(user, "user can't be null");
        Preconditions.checkNotNull(password, "password can't be null");
        AuthUserChangePasswordRequest changePasswordRequest = AuthUserChangePasswordRequest.newBuilder().setNameBytes(ByteString.copyFrom(user.getBytes())).setPasswordBytes(ByteString.copyFrom(password.getBytes())).build();
        return this.completable(this.stub.userChangePassword(changePasswordRequest), AuthUserChangePasswordResponse::new);
    }

    @Override
    public CompletableFuture<AuthUserGetResponse> userGet(ByteSequence user) {
        Preconditions.checkNotNull(user, "user can't be null");
        AuthUserGetRequest userGetRequest = AuthUserGetRequest.newBuilder().setNameBytes(ByteString.copyFrom(user.getBytes())).build();
        return this.completable(this.stub.userGet(userGetRequest), AuthUserGetResponse::new);
    }

    @Override
    public CompletableFuture<AuthUserListResponse> userList() {
        AuthUserListRequest userListRequest = AuthUserListRequest.getDefaultInstance();
        return this.completable(this.stub.userList(userListRequest), AuthUserListResponse::new);
    }

    @Override
    public CompletableFuture<AuthUserGrantRoleResponse> userGrantRole(ByteSequence user, ByteSequence role) {
        Preconditions.checkNotNull(user, "user can't be null");
        Preconditions.checkNotNull(role, "key can't be null");
        AuthUserGrantRoleRequest userGrantRoleRequest = AuthUserGrantRoleRequest.newBuilder().setUserBytes(ByteString.copyFrom(user.getBytes())).setRoleBytes(ByteString.copyFrom(role.getBytes())).build();
        return this.completable(this.stub.userGrantRole(userGrantRoleRequest), AuthUserGrantRoleResponse::new);
    }

    @Override
    public CompletableFuture<AuthUserRevokeRoleResponse> userRevokeRole(ByteSequence user, ByteSequence role) {
        Preconditions.checkNotNull(user, "user can't be null");
        Preconditions.checkNotNull(role, "key can't be null");
        AuthUserRevokeRoleRequest userRevokeRoleRequest = AuthUserRevokeRoleRequest.newBuilder().setNameBytes(ByteString.copyFrom(user.getBytes())).setRoleBytes(ByteString.copyFrom(role.getBytes())).build();
        return this.completable(this.stub.userRevokeRole(userRevokeRoleRequest), AuthUserRevokeRoleResponse::new);
    }

    @Override
    public CompletableFuture<AuthRoleAddResponse> roleAdd(ByteSequence user) {
        Preconditions.checkNotNull(user, "user can't be null");
        AuthRoleAddRequest roleAddRequest = AuthRoleAddRequest.newBuilder().setNameBytes(ByteString.copyFrom(user.getBytes())).build();
        return this.completable(this.stub.roleAdd(roleAddRequest), AuthRoleAddResponse::new);
    }

    @Override
    public CompletableFuture<AuthRoleGrantPermissionResponse> roleGrantPermission(ByteSequence role, ByteSequence key, ByteSequence rangeEnd, Permission.Type permType) {
        Permission.Type type;
        Preconditions.checkNotNull(role, "role can't be null");
        Preconditions.checkNotNull(key, "key can't be null");
        Preconditions.checkNotNull(rangeEnd, "rangeEnd can't be null");
        Preconditions.checkNotNull(permType, "permType can't be null");
        switch (permType) {
            case WRITE: {
                type = Permission.Type.WRITE;
                break;
            }
            case READWRITE: {
                type = Permission.Type.READWRITE;
                break;
            }
            case READ: {
                type = Permission.Type.READ;
                break;
            }
            default: {
                type = Permission.Type.UNRECOGNIZED;
            }
        }
        Permission perm = Permission.newBuilder().setKey(ByteString.copyFrom(key.getBytes())).setRangeEnd(ByteString.copyFrom(rangeEnd.getBytes())).setPermType(type).build();
        AuthRoleGrantPermissionRequest roleGrantPermissionRequest = AuthRoleGrantPermissionRequest.newBuilder().setNameBytes(ByteString.copyFrom(role.getBytes())).setPerm(perm).build();
        return this.completable(this.stub.roleGrantPermission(roleGrantPermissionRequest), AuthRoleGrantPermissionResponse::new);
    }

    @Override
    public CompletableFuture<AuthRoleGetResponse> roleGet(ByteSequence role) {
        Preconditions.checkNotNull(role, "role can't be null");
        AuthRoleGetRequest roleGetRequest = AuthRoleGetRequest.newBuilder().setRoleBytes(ByteString.copyFrom(role.getBytes())).build();
        return this.completable(this.stub.roleGet(roleGetRequest), AuthRoleGetResponse::new);
    }

    @Override
    public CompletableFuture<AuthRoleListResponse> roleList() {
        AuthRoleListRequest roleListRequest = AuthRoleListRequest.getDefaultInstance();
        return this.completable(this.stub.roleList(roleListRequest), AuthRoleListResponse::new);
    }

    @Override
    public CompletableFuture<AuthRoleRevokePermissionResponse> roleRevokePermission(ByteSequence role, ByteSequence key, ByteSequence rangeEnd) {
        Preconditions.checkNotNull(role, "role can't be null");
        Preconditions.checkNotNull(key, "key can't be null");
        Preconditions.checkNotNull(rangeEnd, "rangeEnd can't be null");
        AuthRoleRevokePermissionRequest roleRevokePermissionRequest = AuthRoleRevokePermissionRequest.newBuilder().setRoleBytes(ByteString.copyFrom(role.getBytes())).setKey(ByteString.copyFrom(key.getBytes())).setRangeEnd(ByteString.copyFrom(rangeEnd.getBytes())).build();
        return this.completable(this.stub.roleRevokePermission(roleRevokePermissionRequest), AuthRoleRevokePermissionResponse::new);
    }

    @Override
    public CompletableFuture<AuthRoleDeleteResponse> roleDelete(ByteSequence role) {
        Preconditions.checkNotNull(role, "role can't be null");
        AuthRoleDeleteRequest roleDeleteRequest = AuthRoleDeleteRequest.newBuilder().setRoleBytes(ByteString.copyFrom(role.getBytes())).build();
        return this.completable(this.stub.roleDelete(roleDeleteRequest), AuthRoleDeleteResponse::new);
    }
}

