/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.etcd.jetcd.impl;

import alluxio.shaded.client.io.etcd.jetcd.Cluster;
import alluxio.shaded.client.io.etcd.jetcd.api.MemberAddRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.MemberListRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.MemberRemoveRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.MemberUpdateRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.VertxClusterGrpc;
import alluxio.shaded.client.io.etcd.jetcd.cluster.MemberAddResponse;
import alluxio.shaded.client.io.etcd.jetcd.cluster.MemberListResponse;
import alluxio.shaded.client.io.etcd.jetcd.cluster.MemberRemoveResponse;
import alluxio.shaded.client.io.etcd.jetcd.cluster.MemberUpdateResponse;
import alluxio.shaded.client.io.etcd.jetcd.impl.ClientConnectionManager;
import alluxio.shaded.client.io.etcd.jetcd.impl.Impl;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

final class ClusterImpl
extends Impl
implements Cluster {
    private final VertxClusterGrpc.ClusterVertxStub stub;

    ClusterImpl(ClientConnectionManager connectionManager) {
        super(connectionManager);
        this.stub = connectionManager.newStub(VertxClusterGrpc::newVertxStub);
    }

    @Override
    public CompletableFuture<MemberListResponse> listMember() {
        return this.completable(this.stub.memberList(MemberListRequest.getDefaultInstance()), MemberListResponse::new);
    }

    @Override
    public CompletableFuture<MemberAddResponse> addMember(List<URI> peerAddrs) {
        return this.addMember(peerAddrs, false);
    }

    @Override
    public CompletableFuture<MemberAddResponse> addMember(List<URI> peerAddrs, boolean isLearner) {
        MemberAddRequest memberAddRequest = MemberAddRequest.newBuilder().addAllPeerURLs(peerAddrs.stream().map(URI::toString).collect(Collectors.toList())).setIsLearner(isLearner).build();
        return this.completable(this.stub.memberAdd(memberAddRequest), MemberAddResponse::new);
    }

    @Override
    public CompletableFuture<MemberRemoveResponse> removeMember(long memberID) {
        MemberRemoveRequest memberRemoveRequest = MemberRemoveRequest.newBuilder().setID(memberID).build();
        return this.completable(this.stub.memberRemove(memberRemoveRequest), MemberRemoveResponse::new);
    }

    @Override
    public CompletableFuture<MemberUpdateResponse> updateMember(long memberID, List<URI> peerAddrs) {
        MemberUpdateRequest memberUpdateRequest = MemberUpdateRequest.newBuilder().addAllPeerURLs(peerAddrs.stream().map(URI::toString).collect(Collectors.toList())).setID(memberID).build();
        return this.completable(this.stub.memberUpdate(memberUpdateRequest), MemberUpdateResponse::new);
    }
}

