/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.etcd.jetcd.impl;

import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.io.etcd.jetcd.ByteSequence;
import alluxio.shaded.client.io.etcd.jetcd.KV;
import alluxio.shaded.client.io.etcd.jetcd.Txn;
import alluxio.shaded.client.io.etcd.jetcd.api.CompactionRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.DeleteRangeResponse;
import alluxio.shaded.client.io.etcd.jetcd.api.RangeResponse;
import alluxio.shaded.client.io.etcd.jetcd.api.TxnRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.VertxKVGrpc;
import alluxio.shaded.client.io.etcd.jetcd.impl.ClientConnectionManager;
import alluxio.shaded.client.io.etcd.jetcd.impl.Impl;
import alluxio.shaded.client.io.etcd.jetcd.kv.CompactResponse;
import alluxio.shaded.client.io.etcd.jetcd.kv.DeleteResponse;
import alluxio.shaded.client.io.etcd.jetcd.kv.GetResponse;
import alluxio.shaded.client.io.etcd.jetcd.kv.PutResponse;
import alluxio.shaded.client.io.etcd.jetcd.kv.TxnResponse;
import alluxio.shaded.client.io.etcd.jetcd.op.TxnImpl;
import alluxio.shaded.client.io.etcd.jetcd.options.CompactOption;
import alluxio.shaded.client.io.etcd.jetcd.options.DeleteOption;
import alluxio.shaded.client.io.etcd.jetcd.options.GetOption;
import alluxio.shaded.client.io.etcd.jetcd.options.PutOption;
import alluxio.shaded.client.io.etcd.jetcd.support.Errors;
import alluxio.shaded.client.io.etcd.jetcd.support.Requests;
import java.util.concurrent.CompletableFuture;

final class KVImpl
extends Impl
implements KV {
    private final VertxKVGrpc.KVVertxStub stub;
    private final ByteSequence namespace;

    KVImpl(ClientConnectionManager connectionManager) {
        super(connectionManager);
        this.stub = connectionManager.newStub(VertxKVGrpc::newVertxStub);
        this.namespace = connectionManager.getNamespace();
    }

    @Override
    public CompletableFuture<PutResponse> put(ByteSequence key, ByteSequence value) {
        return this.put(key, value, PutOption.DEFAULT);
    }

    @Override
    public CompletableFuture<PutResponse> put(ByteSequence key, ByteSequence value, PutOption option) {
        Preconditions.checkNotNull(key, "key should not be null");
        Preconditions.checkNotNull(value, "value should not be null");
        Preconditions.checkNotNull(option, "option should not be null");
        return this.execute(() -> this.stub.put(Requests.mapPutRequest(key, value, option, this.namespace)), response -> new PutResponse((alluxio.shaded.client.io.etcd.jetcd.api.PutResponse)response, this.namespace), Errors::isRetryable);
    }

    @Override
    public CompletableFuture<GetResponse> get(ByteSequence key) {
        return this.get(key, GetOption.DEFAULT);
    }

    @Override
    public CompletableFuture<GetResponse> get(ByteSequence key, GetOption option) {
        Preconditions.checkNotNull(key, "key should not be null");
        Preconditions.checkNotNull(option, "option should not be null");
        return this.execute(() -> this.stub.range(Requests.mapRangeRequest(key, option, this.namespace)), response -> new GetResponse((RangeResponse)response, this.namespace), Errors::isRetryable);
    }

    @Override
    public CompletableFuture<DeleteResponse> delete(ByteSequence key) {
        return this.delete(key, DeleteOption.DEFAULT);
    }

    @Override
    public CompletableFuture<DeleteResponse> delete(ByteSequence key, DeleteOption option) {
        Preconditions.checkNotNull(key, "key should not be null");
        Preconditions.checkNotNull(option, "option should not be null");
        return this.execute(() -> this.stub.deleteRange(Requests.mapDeleteRequest(key, option, this.namespace)), response -> new DeleteResponse((DeleteRangeResponse)response, this.namespace), Errors::isRetryable);
    }

    @Override
    public CompletableFuture<CompactResponse> compact(long rev) {
        return this.compact(rev, CompactOption.DEFAULT);
    }

    @Override
    public CompletableFuture<CompactResponse> compact(long rev, CompactOption option) {
        Preconditions.checkNotNull(option, "option should not be null");
        CompactionRequest request = CompactionRequest.newBuilder().setRevision(rev).setPhysical(option.isPhysical()).build();
        return this.execute(() -> this.stub.compact(request), CompactResponse::new, Errors::isRetryable);
    }

    @Override
    public Txn txn() {
        return TxnImpl.newTxn(request -> this.execute(() -> this.stub.txn((TxnRequest)request), response -> new TxnResponse((alluxio.shaded.client.io.etcd.jetcd.api.TxnResponse)response, this.namespace), Errors::isRetryable), this.namespace);
    }
}

