/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.file.impl;

import alluxio.shaded.client.io.netty.util.internal.PlatformDependent;
import alluxio.shaded.client.io.vertx.core.VertxException;
import alluxio.shaded.client.io.vertx.core.file.FileSystemOptions;
import alluxio.shaded.client.io.vertx.core.file.impl.FileCache;
import alluxio.shaded.client.io.vertx.core.file.impl.FileSystemImpl;
import alluxio.shaded.client.io.vertx.core.net.impl.URIDecoder;
import alluxio.shaded.client.io.vertx.core.spi.file.FileResolver;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileResolverImpl
implements FileResolver {
    public static final String DISABLE_FILE_CACHING_PROP_NAME = "vertx.disableFileCaching";
    public static final String DISABLE_CP_RESOLVING_PROP_NAME = "vertx.disableFileCPResolving";
    public static final String CACHE_DIR_BASE_PROP_NAME = "vertx.cacheDirBase";
    private static final boolean NON_UNIX_FILE_SEP = File.separatorChar != '/';
    private static final String JAR_URL_SEP = "!/";
    private final File cwd;
    private final boolean enableCaching;
    private final boolean enableCPResolving;
    private final FileCache cache;

    public FileResolverImpl() {
        this(new FileSystemOptions());
    }

    public FileResolverImpl(FileSystemOptions fileSystemOptions) {
        this.enableCaching = fileSystemOptions.isFileCachingEnabled();
        this.enableCPResolving = fileSystemOptions.isClassPathResolvingEnabled();
        this.cache = this.enableCPResolving ? FileCache.setupCache(fileSystemOptions.getFileCacheDir()) : null;
        String cwdOverride = System.getProperty("vertx.cwd");
        this.cwd = cwdOverride != null ? new File(cwdOverride).getAbsoluteFile() : null;
    }

    public String cacheDir() {
        if (this.cache != null) {
            return this.cache.cacheDir();
        }
        return null;
    }

    FileCache getFileCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.enableCPResolving) {
            FileCache fileCache = this.cache;
            synchronized (fileCache) {
                this.cache.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File resolveFile(String fileName) {
        File file = new File(fileName);
        boolean absolute = file.isAbsolute();
        File resolved = this.cwd != null && !absolute ? new File(this.cwd, fileName) : file;
        if (this.cache == null) {
            return resolved;
        }
        if (!resolved.exists()) {
            FileCache fileCache = this.cache;
            synchronized (fileCache) {
                File cacheFile = this.cache.getCanonicalFile(file);
                if (cacheFile == null) {
                    return file;
                }
                String relativize = this.cache.relativize(cacheFile.getPath());
                if (relativize != null) {
                    if (this.enableCaching && cacheFile.exists()) {
                        return cacheFile;
                    }
                    if (absolute) {
                        fileName = relativize;
                        file = new File(relativize);
                        absolute = false;
                    }
                }
                if (!absolute) {
                    URL url;
                    ClassLoader cl = this.getClassLoader();
                    for (File parentFile = file.getParentFile(); parentFile != null; parentFile = parentFile.getParentFile()) {
                        URL directoryContents;
                        String parentFileName = parentFile.getPath();
                        if (NON_UNIX_FILE_SEP) {
                            parentFileName = parentFileName.replace(File.separatorChar, '/');
                        }
                        if ((directoryContents = FileResolverImpl.getValidClassLoaderResource(cl, parentFileName)) == null) continue;
                        this.unpackUrlResource(directoryContents, parentFileName, cl, true);
                    }
                    if (NON_UNIX_FILE_SEP) {
                        fileName = fileName.replace(File.separatorChar, '/');
                    }
                    if ((url = FileResolverImpl.getValidClassLoaderResource(cl, fileName)) != null) {
                        return this.unpackUrlResource(url, fileName, cl, false);
                    }
                }
            }
        }
        return file;
    }

    private static boolean isValidWindowsCachePath(char c) {
        if (c < ' ') {
            return false;
        }
        switch (c) {
            case '\"': 
            case '*': 
            case ':': 
            case '<': 
            case '>': 
            case '?': 
            case '|': {
                return false;
            }
        }
        return true;
    }

    private static boolean isValidCachePath(String fileName) {
        if (PlatformDependent.isWindows()) {
            int len = fileName.length();
            for (int i = 0; i < len; ++i) {
                char c = fileName.charAt(i);
                if (!FileResolverImpl.isValidWindowsCachePath(c)) {
                    return false;
                }
                if (c != ' ' || i + 1 != len && fileName.charAt(i + 1) != '/') continue;
                return false;
            }
            return true;
        }
        return fileName.indexOf(0) == -1;
    }

    private static URL getValidClassLoaderResource(ClassLoader cl, String fileName) {
        URL resource = cl.getResource(fileName);
        if (resource != null && !FileResolverImpl.isValidCachePath(fileName)) {
            return null;
        }
        return resource;
    }

    private File unpackUrlResource(URL url, String fileName, ClassLoader cl, boolean isDir) {
        String prot;
        switch (prot = url.getProtocol()) {
            case "file": {
                return this.unpackFromFileURL(url, fileName, cl);
            }
            case "jar": {
                return this.unpackFromJarURL(url, fileName, cl);
            }
            case "bundle": 
            case "bundleentry": 
            case "bundleresource": 
            case "jrt": 
            case "resource": 
            case "vfs": {
                return this.unpackFromBundleURL(url, fileName, isDir);
            }
        }
        throw new IllegalStateException("Invalid url protocol: " + prot);
    }

    private File unpackFromFileURL(URL url, String fileName, ClassLoader cl) {
        String[] listing;
        File cacheFile;
        File resource = new File(URIDecoder.decodeURIComponent(url.getPath(), false));
        boolean isDirectory = resource.isDirectory();
        try {
            cacheFile = this.cache.cacheFile(fileName, resource, !this.enableCaching);
        }
        catch (IOException e) {
            throw new VertxException(FileSystemImpl.getFileAccessErrorMessage("unpack", url.toString()), e);
        }
        if (isDirectory && (listing = resource.list()) != null) {
            for (String file : listing) {
                String subResource = fileName + "/" + file;
                URL url2 = FileResolverImpl.getValidClassLoaderResource(cl, subResource);
                if (url2 == null) {
                    throw new VertxException("Invalid resource: " + subResource);
                }
                this.unpackFromFileURL(url2, subResource, cl);
            }
        }
        return cacheFile;
    }

    private File unpackFromJarURL(URL url, String fileName, ClassLoader cl) {
        ZipFile zip = null;
        try {
            String prefixCheck;
            int second;
            int idx2;
            String path = url.getPath();
            int idx1 = path.lastIndexOf(".jar!");
            if (idx1 == -1) {
                idx1 = path.lastIndexOf(".zip!");
            }
            if ((idx2 = path.lastIndexOf(".jar!", idx1 - 1)) == -1) {
                idx2 = path.lastIndexOf(".zip!", idx1 - 1);
            }
            if (idx2 == -1) {
                File file = new File(URIDecoder.decodeURIComponent(path.substring(5, idx1 + 4), false));
                zip = new ZipFile(file);
            } else {
                String s2 = path.substring(idx2 + 6, idx1 + 4);
                File file = this.resolveFile(s2);
                zip = new ZipFile(file);
            }
            String inJarPath = path.substring(idx1 + 6);
            StringBuilder prefixBuilder = new StringBuilder();
            int first = 0;
            int len = JAR_URL_SEP.length();
            while ((second = inJarPath.indexOf(JAR_URL_SEP, first)) >= 0) {
                prefixBuilder.append(inJarPath, first, second).append("/");
                first = second + len;
            }
            String prefix = prefixBuilder.toString();
            Enumeration<? extends ZipEntry> entries = zip.entries();
            String string = prefixCheck = prefix.isEmpty() ? fileName : prefix + fileName;
            while (entries.hasMoreElements()) {
                String p;
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(prefixCheck)) continue;
                String string2 = p = prefix.isEmpty() ? name : name.substring(prefix.length());
                if (name.endsWith("/")) {
                    this.cache.cacheDir(p);
                    continue;
                }
                InputStream is = zip.getInputStream(entry);
                Throwable throwable = null;
                try {
                    this.cache.cacheFile(p, is, !this.enableCaching);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            this.closeQuietly(zip);
        }
        catch (IOException e) {
            try {
                throw new VertxException(FileSystemImpl.getFileAccessErrorMessage("unpack", url.toString()), e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(zip);
                throw throwable;
            }
        }
        return this.cache.getFile(fileName);
    }

    private void closeQuietly(Closeable zip) {
        if (zip != null) {
            try {
                zip.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean isBundleUrlDirectory(URL url) {
        return url.toExternalForm().endsWith("/") || FileResolverImpl.getValidClassLoaderResource(this.getClassLoader(), url.getPath().substring(1) + "/") != null;
    }

    private File unpackFromBundleURL(URL url, String fileName, boolean isDir) {
        block15: {
            try {
                if (this.getClassLoader() != null && this.isBundleUrlDirectory(url) || isDir) {
                    this.cache.cacheDir(fileName);
                    break block15;
                }
                try (InputStream is = url.openStream();){
                    this.cache.cacheFile(fileName, is, !this.enableCaching);
                }
            }
            catch (IOException e) {
                throw new VertxException(FileSystemImpl.getFileAccessErrorMessage("unpack", url.toString()), e);
            }
        }
        return this.cache.getFile(fileName);
    }

    private ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        if (cl == null) {
            cl = Object.class.getClassLoader();
        }
        return cl;
    }
}

