/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.logging;

import alluxio.shaded.client.io.vertx.core.logging.JULLogDelegate;
import alluxio.shaded.client.io.vertx.core.spi.logging.LogDelegate;
import alluxio.shaded.client.io.vertx.core.spi.logging.LogDelegateFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.LogManager;

public class JULLogDelegateFactory
implements LogDelegateFactory {
    public static void loadConfig() {
        try (InputStream is = JULLogDelegateFactory.class.getClassLoader().getResourceAsStream("vertx-default-jul-logging.properties");){
            if (is != null) {
                LogManager.getLogManager().readConfiguration(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public LogDelegate createDelegate(String name) {
        return new JULLogDelegate(name);
    }

    static {
        if (System.getProperty("java.util.logging.config.file") == null) {
            JULLogDelegateFactory.loadConfig();
        }
    }
}

