/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.net.impl;

import alluxio.shaded.client.io.netty.bootstrap.ServerBootstrap;
import alluxio.shaded.client.io.netty.channel.Channel;
import alluxio.shaded.client.io.netty.channel.ChannelFuture;
import alluxio.shaded.client.io.netty.util.concurrent.GenericFutureListener;
import alluxio.shaded.client.io.netty.util.concurrent.Promise;
import alluxio.shaded.client.io.vertx.core.AsyncResult;
import alluxio.shaded.client.io.vertx.core.Future;
import alluxio.shaded.client.io.vertx.core.Handler;
import alluxio.shaded.client.io.vertx.core.impl.VertxInternal;
import alluxio.shaded.client.io.vertx.core.net.SocketAddress;
import alluxio.shaded.client.io.vertx.core.net.impl.SocketAddressImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class AsyncResolveConnectHelper {
    public static alluxio.shaded.client.io.netty.util.concurrent.Future<Channel> doBind(VertxInternal vertx, SocketAddress socketAddress, ServerBootstrap bootstrap) {
        Promise<Channel> promise = vertx.getAcceptorEventLoopGroup().next().newPromise();
        try {
            bootstrap.channelFactory(vertx.transport().serverChannelFactory(socketAddress.isDomainSocket()));
        }
        catch (Exception e) {
            promise.setFailure(e);
            return promise;
        }
        if (socketAddress.isDomainSocket()) {
            java.net.SocketAddress converted = vertx.transport().convert(socketAddress);
            ChannelFuture future = bootstrap.bind(converted);
            future.addListener((GenericFutureListener<? extends alluxio.shaded.client.io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<alluxio.shaded.client.io.netty.util.concurrent.Future>)f -> {
                if (f.isSuccess()) {
                    promise.setSuccess(future.channel());
                } else {
                    promise.setFailure(f.cause());
                }
            }));
        } else {
            SocketAddressImpl impl = (SocketAddressImpl)socketAddress;
            Handler<AsyncResult<InetAddress>> cont = res -> {
                if (res.succeeded()) {
                    InetSocketAddress t = new InetSocketAddress((InetAddress)res.result(), socketAddress.port());
                    ChannelFuture future = bootstrap.bind(t);
                    future.addListener((GenericFutureListener<? extends alluxio.shaded.client.io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<alluxio.shaded.client.io.netty.util.concurrent.Future>)f -> {
                        if (f.isSuccess()) {
                            promise.setSuccess(future.channel());
                        } else {
                            promise.setFailure(f.cause());
                        }
                    }));
                } else {
                    promise.setFailure(res.cause());
                }
            };
            if (impl.ipAddress() != null) {
                cont.handle(Future.succeededFuture(impl.ipAddress()));
            } else {
                vertx.resolveAddress(socketAddress.host(), cont);
            }
        }
        return promise;
    }
}

