/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.net.impl.transport;

import alluxio.shaded.client.io.netty.bootstrap.ServerBootstrap;
import alluxio.shaded.client.io.netty.channel.Channel;
import alluxio.shaded.client.io.netty.channel.ChannelFactory;
import alluxio.shaded.client.io.netty.channel.EventLoopGroup;
import alluxio.shaded.client.io.netty.channel.ServerChannel;
import alluxio.shaded.client.io.netty.channel.kqueue.KQueue;
import alluxio.shaded.client.io.netty.channel.kqueue.KQueueChannelOption;
import alluxio.shaded.client.io.netty.channel.kqueue.KQueueDatagramChannel;
import alluxio.shaded.client.io.netty.channel.kqueue.KQueueDomainSocketChannel;
import alluxio.shaded.client.io.netty.channel.kqueue.KQueueEventLoopGroup;
import alluxio.shaded.client.io.netty.channel.kqueue.KQueueServerDomainSocketChannel;
import alluxio.shaded.client.io.netty.channel.kqueue.KQueueServerSocketChannel;
import alluxio.shaded.client.io.netty.channel.kqueue.KQueueSocketChannel;
import alluxio.shaded.client.io.netty.channel.socket.DatagramChannel;
import alluxio.shaded.client.io.netty.channel.socket.InternetProtocolFamily;
import alluxio.shaded.client.io.netty.channel.unix.DomainSocketAddress;
import alluxio.shaded.client.io.vertx.core.datagram.DatagramSocketOptions;
import alluxio.shaded.client.io.vertx.core.net.NetServerOptions;
import alluxio.shaded.client.io.vertx.core.net.SocketAddress;
import alluxio.shaded.client.io.vertx.core.net.impl.SocketAddressImpl;
import alluxio.shaded.client.io.vertx.core.net.impl.transport.Transport;
import java.util.concurrent.ThreadFactory;

class KQueueTransport
extends Transport {
    KQueueTransport() {
    }

    @Override
    public java.net.SocketAddress convert(SocketAddress address) {
        if (address.isDomainSocket()) {
            return new DomainSocketAddress(address.path());
        }
        return super.convert(address);
    }

    @Override
    public SocketAddress convert(java.net.SocketAddress address) {
        if (address instanceof DomainSocketAddress) {
            return new SocketAddressImpl(((DomainSocketAddress)address).path());
        }
        return super.convert(address);
    }

    @Override
    public boolean isAvailable() {
        return KQueue.isAvailable();
    }

    @Override
    public Throwable unavailabilityCause() {
        return KQueue.unavailabilityCause();
    }

    @Override
    public EventLoopGroup eventLoopGroup(int type, int nThreads, ThreadFactory threadFactory, int ioRatio) {
        KQueueEventLoopGroup eventLoopGroup = new KQueueEventLoopGroup(nThreads, threadFactory);
        eventLoopGroup.setIoRatio(ioRatio);
        return eventLoopGroup;
    }

    @Override
    public DatagramChannel datagramChannel() {
        return new KQueueDatagramChannel();
    }

    @Override
    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        return new KQueueDatagramChannel();
    }

    @Override
    public ChannelFactory<? extends Channel> channelFactory(boolean domainSocket) {
        if (domainSocket) {
            return KQueueDomainSocketChannel::new;
        }
        return KQueueSocketChannel::new;
    }

    @Override
    public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean domainSocket) {
        if (domainSocket) {
            return KQueueServerDomainSocketChannel::new;
        }
        return KQueueServerSocketChannel::new;
    }

    @Override
    public void configure(NetServerOptions options, boolean domainSocket, ServerBootstrap bootstrap) {
        if (!domainSocket) {
            bootstrap.option(KQueueChannelOption.SO_REUSEPORT, options.isReusePort());
        }
        super.configure(options, domainSocket, bootstrap);
    }

    @Override
    public void configure(DatagramChannel channel, DatagramSocketOptions options) {
        channel.config().setOption(KQueueChannelOption.SO_REUSEPORT, options.isReusePort());
        super.configure(channel, options);
    }
}

