/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.software.amazon.ionimpl;

import alluxio.shaded.client.software.amazon.ionIonCatalog;
import alluxio.shaded.client.software.amazon.ionIonSystem;
import alluxio.shaded.client.software.amazon.ionIonType;
import alluxio.shaded.client.software.amazon.ionOffsetSpan;
import alluxio.shaded.client.software.amazon.ionSeekableReader;
import alluxio.shaded.client.software.amazon.ionSpan;
import alluxio.shaded.client.software.amazon.ionSpanProvider;
import alluxio.shaded.client.software.amazon.ionSymbolTable;
import alluxio.shaded.client.software.amazon.ionSymbolToken;
import alluxio.shaded.client.software.amazon.ionTextSpan;
import alluxio.shaded.client.software.amazon.ionUnsupportedIonVersionException;
import alluxio.shaded.client.software.amazon.ionValueFactory;
import alluxio.shaded.client.software.amazon.ionimpl.DowncastingFaceted;
import alluxio.shaded.client.software.amazon.ionimpl.IonReaderTextSystemX;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateReaderWriter;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateUtils;
import alluxio.shaded.client.software.amazon.ionimpl.UnifiedDataPageX;
import alluxio.shaded.client.software.amazon.ionimpl.UnifiedInputStreamX;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IonReaderTextUserX
extends IonReaderTextSystemX
implements PrivateReaderWriter {
    private static final Pattern ION_VERSION_MARKER_REGEX = Pattern.compile("^\\$ion_[0-9]+_[0-9]+$");
    private final int _physical_start_offset;
    ionIonCatalog _catalog;
    ionSymbolTable _symbols;
    private int _symbol_table_top = 0;
    private ionSymbolTable[] _symbol_table_stack = new ionSymbolTable[3];

    protected IonReaderTextUserX(ionIonSystem system, ionIonCatalog catalog, UnifiedInputStreamX uis, int physicalStartOffset) {
        super(system, uis);
        this._physical_start_offset = physicalStartOffset;
        this.initUserReader(system, catalog);
    }

    protected IonReaderTextUserX(ionIonSystem system, ionIonCatalog catalog, UnifiedInputStreamX uis) {
        super(system, uis);
        this._physical_start_offset = 0;
        this.initUserReader(system, catalog);
    }

    private void initUserReader(ionIonSystem system, ionIonCatalog catalog) {
        if (system == null) {
            throw new IllegalArgumentException();
        }
        this._system = system;
        this._catalog = catalog != null ? catalog : system.getCatalog();
    }

    @Override
    public ionIonSystem getSystem() {
        return this._system;
    }

    @Override
    boolean hasNext() {
        boolean has_next = this.has_next_user_value();
        return has_next;
    }

    private final boolean has_next_user_value() {
        this.clear_system_value_stack();
        block4: while (!this._has_next_called) {
            this.has_next_raw_value();
            if (this._value_type == null || this.isNullValue() || !ionIonType.DATAGRAM.equals((Object)this.getContainerType())) continue;
            switch (this._value_type) {
                case STRUCT: {
                    if (this._annotation_count <= 0) continue block4;
                    for (int ii = 0; ii < this._annotation_count; ++ii) {
                        ionSymbolToken a = this._annotations[ii];
                        if (!"$ion_symbol_table".equals(a.getText())) continue;
                        this._symbols = PrivateUtils.newLocalSymtab((ionValueFactory)this._system, this._system.getSystemSymbolTable(), this._catalog, this, true);
                        this.push_symbol_table(this._symbols);
                        this._has_next_called = false;
                        continue block4;
                    }
                    continue block4;
                }
                case SYMBOL: {
                    String version;
                    if (this._annotation_count != 0 || !IonReaderTextUserX.isIonVersionMarker(version = this.symbolValue().getText())) continue block4;
                    if ("$ion_1_0".equals(version)) {
                        this.symbol_table_reset();
                        this.push_symbol_table(this._system.getSystemSymbolTable());
                        this._has_next_called = false;
                        continue block4;
                    }
                    throw new ionUnsupportedIonVersionException(version);
                }
            }
        }
        return !this._eof;
    }

    private static boolean isIonVersionMarker(String text) {
        return text != null && ION_VERSION_MARKER_REGEX.matcher(text).matches();
    }

    private final void symbol_table_reset() {
        ionIonType t = this.next();
        assert (ionIonType.SYMBOL.equals((Object)t));
        this._symbols = null;
    }

    @Override
    public ionSymbolTable getSymbolTable() {
        if (this._symbols == null) {
            ionSymbolTable system_symbols = this._system.getSystemSymbolTable();
            this._symbols = PrivateUtils.newLocalSymtab((ionValueFactory)this._system, system_symbols, new ionSymbolTable[0]);
        }
        return this._symbols;
    }

    private void clear_system_value_stack() {
        while (this._symbol_table_top > 0) {
            --this._symbol_table_top;
            this._symbol_table_stack[this._symbol_table_top] = null;
        }
    }

    private void push_symbol_table(ionSymbolTable symbols) {
        assert (symbols != null);
        if (this._symbol_table_top >= this._symbol_table_stack.length) {
            int new_len = this._symbol_table_stack.length * 2;
            ionSymbolTable[] temp = new ionSymbolTable[new_len];
            System.arraycopy(this._symbol_table_stack, 0, temp, 0, this._symbol_table_stack.length);
            this._symbol_table_stack = temp;
        }
        this._symbol_table_stack[this._symbol_table_top++] = symbols;
    }

    @Override
    public ionSymbolTable pop_passed_symbol_table() {
        if (this._symbol_table_top <= 0) {
            return null;
        }
        --this._symbol_table_top;
        ionSymbolTable symbols = this._symbol_table_stack[this._symbol_table_top];
        this._symbol_table_stack[this._symbol_table_top] = null;
        return symbols;
    }

    public ionSpan currentSpanImpl() {
        if (this.getType() == null) {
            throw new IllegalStateException("must be on a value");
        }
        IonReaderTextSpan pos = new IonReaderTextSpan(this);
        return pos;
    }

    private void hoistImpl(ionSpan span) {
        UnifiedInputStreamX iis;
        if (!(span instanceof IonReaderTextSpan)) {
            throw new IllegalArgumentException("position must match the reader");
        }
        IonReaderTextSpan text_span = (IonReaderTextSpan)span;
        UnifiedInputStreamX current_stream = this._scanner.getSourceStream();
        UnifiedDataPageX curr_page = text_span.getDataPage();
        int array_offset = (int)text_span._start_offset + this._physical_start_offset;
        int page_limit = curr_page._page_limit;
        int array_length = page_limit - array_offset;
        assert (text_span.getStartOffset() <= Integer.MAX_VALUE);
        if (current_stream._is_byte_data) {
            byte[] bytes = current_stream.getByteArray();
            assert (bytes != null);
            iis = UnifiedInputStreamX.makeStream(bytes, array_offset, array_length);
        } else {
            char[] chars = current_stream.getCharArray();
            assert (chars != null);
            iis = UnifiedInputStreamX.makeStream(chars, array_offset, array_length);
        }
        ionIonType container = text_span.getContainerType();
        this.re_init(iis, container, text_span._start_line, text_span._start_column);
    }

    @Override
    public <T> T asFacet(Class<T> facetType) {
        if (facetType == ionSpanProvider.class) {
            return facetType.cast(new SpanProviderFacet());
        }
        if (facetType == ionSeekableReader.class && this._scanner.isBufferedInput()) {
            return facetType.cast(new SeekableReaderFacet());
        }
        return super.asFacet(facetType);
    }

    private final class SeekableReaderFacet
    extends SpanProviderFacet
    implements ionSeekableReader {
        private SeekableReaderFacet() {
        }

        public void hoist(ionSpan span) {
            IonReaderTextUserX.this.hoistImpl(span);
        }
    }

    private class SpanProviderFacet
    implements ionSpanProvider {
        private SpanProviderFacet() {
        }

        public ionSpan currentSpan() {
            return IonReaderTextUserX.this.currentSpanImpl();
        }
    }

    private static final class IonReaderTextSpan
    extends DowncastingFaceted
    implements ionSpan,
    ionTextSpan,
    ionOffsetSpan {
        private final UnifiedDataPageX _data_page;
        private final ionIonType _container_type;
        private final long _start_offset;
        private final long _start_line;
        private final long _start_column;

        IonReaderTextSpan(IonReaderTextUserX reader) {
            UnifiedInputStreamX current_stream = reader._scanner.getSourceStream();
            this._data_page = current_stream._buffer.getCurrentPage();
            this._container_type = reader.getContainerType();
            this._start_offset = reader._value_start_offset - (long)reader._physical_start_offset;
            this._start_line = reader._value_start_line;
            this._start_column = reader._value_start_column;
        }

        public long getStartLine() {
            if (this._start_line < 1L) {
                throw new IllegalStateException("not positioned on a reader");
            }
            return this._start_line;
        }

        public long getStartColumn() {
            if (this._start_column < 0L) {
                throw new IllegalStateException("not positioned on a reader");
            }
            return this._start_column;
        }

        public long getFinishLine() {
            return -1L;
        }

        public long getFinishColumn() {
            return -1L;
        }

        public long getStartOffset() {
            return this._start_offset;
        }

        public long getFinishOffset() {
            return -1L;
        }

        ionIonType getContainerType() {
            return this._container_type;
        }

        UnifiedDataPageX getDataPage() {
            return this._data_page;
        }
    }
}

