/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block;

import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.worker.block.BlockStoreLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ThreadSafe
public final class BlockHeartbeatReport {
    private final Map<BlockStoreLocation, List<Long>> mAddedBlocks;
    private final List<Long> mRemovedBlocks;
    private final Map<String, List<String>> mLostStorage;

    public BlockHeartbeatReport(Map<BlockStoreLocation, List<Long>> addedBlocks, List<Long> removedBlocks, Map<String, List<String>> lostStorage) {
        this.mAddedBlocks = new HashMap<BlockStoreLocation, List<Long>>(addedBlocks);
        this.mRemovedBlocks = new ArrayList<Long>(removedBlocks);
        this.mLostStorage = new HashMap<String, List<String>>(lostStorage);
    }

    public Map<BlockStoreLocation, List<Long>> getAddedBlocks() {
        return Collections.unmodifiableMap(this.mAddedBlocks);
    }

    public List<Long> getRemovedBlocks() {
        return Collections.unmodifiableList(this.mRemovedBlocks);
    }

    public Map<String, List<String>> getLostStorage() {
        return Collections.unmodifiableMap(this.mLostStorage);
    }

    public int getBlockChangeCount() {
        int count = this.mRemovedBlocks.size();
        for (List<Long> blocks : this.mAddedBlocks.values()) {
            count += blocks.size();
        }
        return count;
    }
}

