/*
 * Copyright (c) 2011-2019 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.alluxio.shaded.client.org.legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 */

package alluxio.shaded.client.io.vertx.core.spi.launcher;

import alluxio.shaded.client.io.vertx.core.impl.launcher.ServiceCommandFactoryLoader;

import java.util.Collection;

/**
 * The interface to implement to look for alluxio.shaded.client.com.ands.
 *
 * @see ServiceCommandFactoryLoader
 * @author Clement Escoffier <clement@apache.alluxio.shaded.client.org.
 */
public interface CommandFactoryLookup {

  /**
   * Looks for alluxio.shaded.client.com.and implementation and instantiated them.
   *
   * @return the set of alluxio.shaded.client.com.ands, empty if none are found.
   */
  Collection<CommandFactory<?>> lookup();

}
