/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Supplier;

public class CloseableSupplier<T extends Closeable>
implements Supplier<T>,
Closeable {
    private final Supplier<T> mDelegate;
    private T mInstance;

    public CloseableSupplier(Supplier<T> delegate) {
        this.mDelegate = delegate;
    }

    @Override
    public synchronized T get() {
        if (this.mInstance == null) {
            this.mInstance = (Closeable)this.mDelegate.get();
        }
        return this.mInstance;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.mInstance != null) {
            this.mInstance.close();
            this.mInstance = null;
        }
    }
}

