/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.ufs;

import alluxio.AlluxioURI;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.dora.DoraCacheClient;
import alluxio.client.file.options.OutStreamOptions;
import alluxio.exception.runtime.PermissionDeniedRuntimeException;
import alluxio.exception.status.PermissionDeniedException;
import alluxio.grpc.CompleteFilePOptions;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.io.Closer;
import alluxio.util.CommonUtils;
import java.io.IOException;

public class DoraOutStream
extends FileOutStream {
    private final Closer mCloser = Closer.create();
    private final FileSystemContext mContext;
    private final OutStreamOptions mOptions;
    private boolean mClosed;
    private final AlluxioURI mUri;
    private final DoraCacheClient mDoraClient;
    private final String mUuid;

    public DoraOutStream(AlluxioURI path, OutStreamOptions options, FileSystemContext context, String uuid, DoraCacheClient doraClient) throws IOException {
        this.mContext = context;
        this.mCloser.register(this.mContext.blockReinit());
        this.mDoraClient = doraClient;
        try {
            this.mUri = Preconditions.checkNotNull(path, "path");
            this.mOptions = options;
            this.mClosed = false;
            this.mBytesWritten = 0L;
            this.mUuid = uuid;
        }
        catch (Throwable t) {
            throw CommonUtils.closeAndRethrow(this.mCloser, t);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.mOptions.toString();
    }

    @Override
    public void close() {
        if (!this.mClosed) {
            CompleteFilePOptions options = CompleteFilePOptions.newBuilder().setUfsLength(12345L).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().build()).setContentHash("HASH-256").build();
            this.mClosed = true;
            try {
                this.mDoraClient.completeFile(this.mUri.toString(), options, this.mUuid);
            }
            catch (PermissionDeniedException e) {
                throw new PermissionDeniedRuntimeException(e);
            }
        }
    }
}

