/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.quota;

import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ThreadSafe
public class CacheScope {
    private static final String GLOBAL_ID = ".";
    public static final String SEPARATOR = ".";
    public static final CacheScope GLOBAL = new CacheScope(".", 1, Level.GLOBAL);
    private final String mId;
    private final int mLength;
    private final Level mLevel;

    public static CacheScope create(String id) {
        Preconditions.checkArgument(id != null && id.length() > 0, "scope id can not be null or empty string");
        if (".".equals(id)) {
            return GLOBAL;
        }
        if (Level.SCHEMA.matches(id)) {
            return new CacheScope(id, id.length(), Level.SCHEMA);
        }
        if (Level.TABLE.matches(id)) {
            return new CacheScope(id, id.length(), Level.TABLE);
        }
        if (Level.PARTITION.matches(id)) {
            return new CacheScope(id, id.length(), Level.PARTITION);
        }
        throw new IllegalArgumentException("Failed to parse cache scope: " + id);
    }

    private CacheScope(String id, int len, Level level) {
        this.mId = id;
        this.mLength = len;
        this.mLevel = level;
    }

    @Nullable
    public CacheScope parent() {
        int r = this.mId.lastIndexOf(".", this.mLength - 1);
        if (r < 0) {
            return GLOBAL;
        }
        if (r == 0) {
            return null;
        }
        return new CacheScope(this.mId, r, this.mLevel.parent());
    }

    public Level level() {
        return this.mLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheScope cacheScope = (CacheScope)o;
        if (this.mLength != cacheScope.mLength) {
            return false;
        }
        if (Objects.equal(this.mId, cacheScope.mId)) {
            return true;
        }
        return Objects.equal(this.mId.substring(0, this.mLength), cacheScope.mId.substring(0, cacheScope.mLength));
    }

    public int hashCode() {
        return Objects.hashCode(this.mId.substring(0, this.mLength), this.mLength);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.mId.substring(0, this.mLength)).toString();
    }

    public static enum Level {
        GLOBAL("\\."),
        SCHEMA("\\w+"),
        TABLE("\\w+\\.\\w+"),
        PARTITION("\\w+\\.\\w+.\\w+");

        private final Pattern mPattern;

        private Level(String re) {
            this.mPattern = Pattern.compile(re);
        }

        @Nullable
        public Level parent() {
            if (this.ordinal() > 0) {
                return Level.values()[this.ordinal() - 1];
            }
            return null;
        }

        public boolean matches(String input) {
            Matcher matcher = this.mPattern.matcher(input);
            return matcher.matches();
        }
    }
}

