/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics;

import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.shaded.client.io.prometheus.metrics.config.PrometheusProperties;
import alluxio.shaded.client.io.prometheus.metrics.core.metrics.Counter;
import alluxio.shaded.client.io.prometheus.metrics.core.metrics.Gauge;
import alluxio.shaded.client.io.prometheus.metrics.core.metrics.GaugeWithCallback;
import alluxio.shaded.client.io.prometheus.metrics.core.metrics.Histogram;
import alluxio.shaded.client.io.prometheus.metrics.core.metrics.Summary;
import alluxio.shaded.client.io.prometheus.metrics.exporter.common.PrometheusHttpRequest;
import alluxio.shaded.client.io.prometheus.metrics.exporter.common.PrometheusHttpResponse;
import alluxio.shaded.client.io.prometheus.metrics.exporter.common.PrometheusScrapeHandler;
import alluxio.shaded.client.io.prometheus.metrics.exporter.servlet.jakarta.HttpExchangeAdapter;
import alluxio.shaded.client.io.prometheus.metrics.instrumentation.jvm.JvmMetrics;
import alluxio.shaded.client.io.prometheus.metrics.model.registry.PrometheusRegistry;
import alluxio.shaded.client.io.prometheus.metrics.model.snapshots.Unit;
import alluxio.shaded.client.org.eclipse.jetty.servlet.ServletContextHandler;
import alluxio.shaded.client.org.eclipse.jetty.servlet.ServletHolder;
import alluxio.util.CommonUtils;
import alluxio.util.FormatUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class MultiDimensionalMetricsSystem {
    public static final Histogram DATA_ACCESS = ((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.builder().name("alluxio_data_access")).help("aggregated throughput of all the data access")).unit(Unit.BYTES)).labelNames("method")).build();
    public static final Summary DATA_ACCESS_LATENCY = ((Summary.Builder)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.builder().name("alluxio_data_access_latency")).help("aggregated latency of all the data access")).unit(Unit.SECONDS)).labelNames("method")).build();
    public static final Histogram UFS_DATA_ACCESS = ((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.builder().name("alluxio_ufs_data_access")).help("aggregated throughput of ufs access")).unit(Unit.BYTES)).labelNames("method")).build();
    public static final Summary UFS_DATA_ACCESS_LATENCY = ((Summary.Builder)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.builder().name("alluxio_ufs_data_access_latency")).help("aggregated latency of ufs access")).unit(Unit.SECONDS)).labelNames("method")).build();
    public static final Counter META_OPERATION = ((Counter.Builder)((Counter.Builder)Counter.builder().name("alluxio_meta_operation").help("counter of rpc calls of the meta operations")).labelNames("op")).build();
    public static final Counter CACHED_DATA_READ = ((Counter.Builder)((Counter.Builder)Counter.builder().name("alluxio_cached_data_read").help("amount of the read cached data")).unit(Unit.BYTES)).build();
    public static final Counter CACHED_EVICTED_DATA = ((Counter.Builder)((Counter.Builder)Counter.builder().name("alluxio_cached_evicted_data").help("amount of the evicted data")).unit(Unit.BYTES)).build();
    public static final Gauge CACHED_STORAGE = ((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("alluxio_cached_storage")).help("amount of the cached data")).unit(Unit.BYTES)).build();
    public static final GaugeWithCallback CACHED_CAPACITY = ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("alluxio_cached_capacity")).help("configured maximum cache storage")).unit(Unit.BYTES)).callback(callback -> {
        List<String> sizes = Configuration.global().getList(PropertyKey.WORKER_PAGE_STORE_SIZES);
        long sum = sizes.stream().map(FormatUtils::parseSpaceSize).reduce(0L, Long::sum);
        callback.call(sum, new String[0]);
    }).build();
    public static final Counter DISTRIBUTED_LOAD_FAILURE = (Counter)((Counter.Builder)((Counter.Builder)Counter.builder().name("alluxio_distributed_load_failure").help("counter of rpc calls of the meta operations")).labelNames("reason", "final_attempt")).register();

    public static void initMetrics() {
        JvmMetrics.builder().register();
        switch (CommonUtils.PROCESS_TYPE.get()) {
            case MASTER: {
                break;
            }
            case WORKER: {
                PrometheusRegistry.defaultRegistry.register(DATA_ACCESS);
                PrometheusRegistry.defaultRegistry.register(DATA_ACCESS_LATENCY);
                PrometheusRegistry.defaultRegistry.register(UFS_DATA_ACCESS);
                PrometheusRegistry.defaultRegistry.register(UFS_DATA_ACCESS_LATENCY);
                PrometheusRegistry.defaultRegistry.register(META_OPERATION);
                PrometheusRegistry.defaultRegistry.register(CACHED_DATA_READ);
                PrometheusRegistry.defaultRegistry.register(CACHED_EVICTED_DATA);
                PrometheusRegistry.defaultRegistry.register(CACHED_STORAGE);
                PrometheusRegistry.defaultRegistry.register(CACHED_CAPACITY);
                break;
            }
            case CLIENT: {
                PrometheusRegistry.defaultRegistry.register(DATA_ACCESS);
                PrometheusRegistry.defaultRegistry.register(DATA_ACCESS_LATENCY);
                PrometheusRegistry.defaultRegistry.register(META_OPERATION);
                PrometheusRegistry.defaultRegistry.register(CACHED_DATA_READ);
                PrometheusRegistry.defaultRegistry.register(CACHED_EVICTED_DATA);
                PrometheusRegistry.defaultRegistry.register(CACHED_STORAGE);
                PrometheusRegistry.defaultRegistry.register(CACHED_CAPACITY);
                break;
            }
        }
    }

    private static class ServletAdapter
    extends HttpExchangeAdapter {
        private final Request mRequest;
        private final Response mResponse;

        public ServletAdapter(HttpServletRequest request, HttpServletResponse response) {
            super(null, null);
            this.mRequest = new Request(request);
            this.mResponse = new Response(response);
        }

        @Override
        public PrometheusHttpRequest getRequest() {
            return this.mRequest;
        }

        @Override
        public PrometheusHttpResponse getResponse() {
            return this.mResponse;
        }

        @Override
        public void handleException(IOException e) throws IOException {
            throw e;
        }

        @Override
        public void handleException(RuntimeException e) {
            throw e;
        }

        @Override
        public void close() {
        }

        private static class Response
        implements PrometheusHttpResponse {
            private final HttpServletResponse mResponse;

            public Response(HttpServletResponse response) {
                this.mResponse = response;
            }

            @Override
            public void setHeader(String name, String value) {
                this.mResponse.setHeader(name, value);
            }

            @Override
            public OutputStream sendHeadersAndGetBody(int statusCode, int contentLength) throws IOException {
                if (this.mResponse.getHeader("Content-Length") == null && contentLength > 0) {
                    this.mResponse.setContentLength(contentLength);
                }
                this.mResponse.setStatus(statusCode);
                return this.mResponse.getOutputStream();
            }
        }

        private static class Request
        implements PrometheusHttpRequest {
            private final HttpServletRequest mRequest;

            public Request(HttpServletRequest request) {
                this.mRequest = request;
            }

            @Override
            public String getQueryString() {
                return this.mRequest.getQueryString();
            }

            @Override
            public Enumeration<String> getHeaders(String name) {
                return this.mRequest.getHeaders(name);
            }

            @Override
            public String getMethod() {
                return this.mRequest.getMethod();
            }
        }
    }

    public static class WebHandler
    extends HttpServlet {
        private static final long serialVersionUID = 1L;
        private static final String SERVLET_PATH = "/metrics";
        private final PrometheusScrapeHandler mHandler = new PrometheusScrapeHandler(PrometheusProperties.get(), PrometheusRegistry.defaultRegistry);

        public static ServletContextHandler getHandler() {
            ServletContextHandler contextHandler = new ServletContextHandler();
            contextHandler.setContextPath(SERVLET_PATH);
            contextHandler.addServlet(new ServletHolder(new WebHandler()), "/");
            return contextHandler;
        }

        @Override
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            this.mHandler.handleRequest(new ServletAdapter(req, resp));
        }
    }
}

