/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.grpc.stub;

import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.io.grpc.StatusException;
import alluxio.shaded.client.io.grpc.StatusRuntimeException;
import alluxio.shaded.client.io.grpc.stub.ServerCallStreamObserver;
import alluxio.shaded.client.io.grpc.stub.StreamObserver;
import alluxio.shaded.client.io.vertx.core.Future;
import alluxio.shaded.client.io.vertx.core.streams.ReadStream;
import alluxio.shaded.client.io.vertx.core.streams.WriteStream;
import alluxio.shaded.client.io.vertx.grpc.stub.GrpcWriteStream;
import alluxio.shaded.client.io.vertx.grpc.stub.StreamObserverReadStream;
import java.util.function.BiConsumer;
import java.util.function.Function;

public final class ServerCalls {
    private ServerCalls() {
    }

    public static <I, O> void oneToOne(I request, StreamObserver<O> response, String compression, Function<I, Future<O>> delegate) {
        ServerCalls.trySetCompression(response, compression);
        try {
            Future<O> future = delegate.apply(request);
            future.onComplete(res -> {
                if (res.succeeded()) {
                    response.onNext(res.result());
                    response.onCompleted();
                } else {
                    response.onError(ServerCalls.prepareError(res.cause()));
                }
            });
        }
        catch (Throwable throwable) {
            response.onError(ServerCalls.prepareError(throwable));
        }
    }

    public static <I, O> void oneToMany(I request, StreamObserver<O> response, String compression, BiConsumer<I, WriteStream<O>> delegate) {
        ServerCalls.trySetCompression(response, compression);
        try {
            GrpcWriteStream<O> responseWriteStream = new GrpcWriteStream<O>(response);
            delegate.accept(request, responseWriteStream);
        }
        catch (Throwable throwable) {
            response.onError(ServerCalls.prepareError(throwable));
        }
    }

    public static <I, O> StreamObserver<I> manyToOne(StreamObserver<O> response, String compression, Function<ReadStream<I>, Future<O>> delegate) {
        ServerCalls.trySetCompression(response, compression);
        StreamObserverReadStream request = new StreamObserverReadStream();
        Future<O> future = delegate.apply(request);
        future.onComplete(res -> {
            if (res.succeeded()) {
                response.onNext(res.result());
                response.onCompleted();
            } else {
                response.onError(ServerCalls.prepareError(res.cause()));
            }
        });
        return request;
    }

    public static <I, O> StreamObserver<I> manyToMany(StreamObserver<O> response, String compression, BiConsumer<ReadStream<I>, WriteStream<O>> delegate) {
        ServerCalls.trySetCompression(response, compression);
        StreamObserverReadStream request = new StreamObserverReadStream();
        GrpcWriteStream<O> responseStream = new GrpcWriteStream<O>(response);
        delegate.accept(request, responseStream);
        return request;
    }

    private static void trySetCompression(StreamObserver<?> response, String compression) {
        if (compression != null && response instanceof ServerCallStreamObserver) {
            ServerCallStreamObserver serverResponse = (ServerCallStreamObserver)response;
            serverResponse.setCompression(compression);
        }
    }

    private static Throwable prepareError(Throwable throwable) {
        if (throwable instanceof StatusException || throwable instanceof StatusRuntimeException) {
            return throwable;
        }
        return Status.fromThrowable(throwable).asException();
    }
}

