/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.net.jodah.failsafe;

import alluxio.shaded.client.net.jodah.failsafe.AbstractExecution;
import alluxio.shaded.client.net.jodah.failsafe.AsyncExecution;
import alluxio.shaded.client.net.jodah.failsafe.ExecutionContext;
import alluxio.shaded.client.net.jodah.failsafe.ExecutionResult;
import alluxio.shaded.client.net.jodah.failsafe.function.AsyncRunnable;
import alluxio.shaded.client.net.jodah.failsafe.function.AsyncSupplier;
import alluxio.shaded.client.net.jodah.failsafe.function.CheckedConsumer;
import alluxio.shaded.client.net.jodah.failsafe.function.CheckedFunction;
import alluxio.shaded.client.net.jodah.failsafe.function.CheckedRunnable;
import alluxio.shaded.client.net.jodah.failsafe.function.CheckedSupplier;
import alluxio.shaded.client.net.jodah.failsafe.function.ContextualRunnable;
import alluxio.shaded.client.net.jodah.failsafe.function.ContextualSupplier;
import alluxio.shaded.client.net.jodah.failsafe.internal.util.Assert;
import alluxio.shaded.client.net.jodah.failsafe.util.concurrent.Scheduler;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

final class Functions {
    Functions() {
    }

    static <R> Supplier<ExecutionResult> get(CheckedSupplier<R> supplier, AbstractExecution<R> execution) {
        return () -> {
            ExecutionResult result;
            Throwable throwable = null;
            try {
                execution.preExecute();
                result = ExecutionResult.success(supplier.get());
            }
            catch (Throwable t) {
                throwable = t;
                result = ExecutionResult.failure(t);
            }
            finally {
                AbstractExecution abstractExecution = execution;
                synchronized (abstractExecution) {
                    execution.canInterrupt = false;
                    if (execution.interrupted) {
                        Thread.interrupted();
                    } else if (throwable instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            execution.record(result);
            return result;
        };
    }

    static <R> Supplier<CompletableFuture<ExecutionResult>> getPromise(ContextualSupplier<R, R> supplier, AbstractExecution<R> execution) {
        Assert.notNull(supplier, "supplier");
        return () -> {
            ExecutionResult result;
            try {
                execution.preExecute();
                result = ExecutionResult.success(supplier.get(execution));
            }
            catch (Throwable t) {
                result = ExecutionResult.failure(t);
            }
            execution.record(result);
            return CompletableFuture.completedFuture(result);
        };
    }

    static <R> Supplier<CompletableFuture<ExecutionResult>> getPromiseAsync(Supplier<CompletableFuture<ExecutionResult>> supplier, Scheduler scheduler, AsyncExecution<R> execution) {
        AtomicBoolean scheduled = new AtomicBoolean();
        return () -> {
            if (scheduled.get()) {
                return (CompletableFuture)supplier.get();
            }
            CompletableFuture promise = new CompletableFuture();
            Callable<Object> callable = () -> Functions.lambda$null$3((Supplier)supplier, promise);
            try {
                scheduled.set(true);
                ScheduledFuture<?> scheduledSupply = scheduler.schedule(callable, 0L, TimeUnit.NANOSECONDS);
                execution.future.injectCancelFn((mayInterrupt, cancelResult) -> {
                    scheduledSupply.cancel((boolean)mayInterrupt);
                    if (!execution.inProgress) {
                        promise.complete(cancelResult);
                    }
                });
            }
            catch (Throwable t) {
                promise.completeExceptionally(t);
            }
            return promise;
        };
    }

    static <R> Supplier<CompletableFuture<ExecutionResult>> getPromiseExecution(final AsyncRunnable<R> runnable, final AsyncExecution<R> execution) {
        Assert.notNull(runnable, "runnable");
        return new Supplier<CompletableFuture<ExecutionResult>>(){

            @Override
            public synchronized CompletableFuture<ExecutionResult> get() {
                try {
                    execution.preExecute();
                    runnable.run(execution);
                }
                catch (Throwable e) {
                    execution.completeOrHandle(null, e);
                }
                return ExecutionResult.NULL_FUTURE;
            }
        };
    }

    static <R> Supplier<CompletableFuture<ExecutionResult>> getPromiseOfStage(ContextualSupplier<R, ? extends CompletionStage<? extends R>> supplier, AsyncExecution<R> execution) {
        Assert.notNull(supplier, "supplier");
        return () -> {
            CompletableFuture<ExecutionResult> promise = new CompletableFuture<ExecutionResult>();
            try {
                execution.preExecute();
                CompletionStage stage = (CompletionStage)supplier.get(execution);
                if (stage instanceof Future) {
                    execution.future.injectStage((Future)((Object)stage));
                }
                stage.whenComplete((result, failure) -> {
                    if (failure instanceof CompletionException) {
                        failure = failure.getCause();
                    }
                    ExecutionResult r = failure == null ? ExecutionResult.success(result) : ExecutionResult.failure(failure);
                    execution.record(r);
                    promise.complete(r);
                });
            }
            catch (Throwable t) {
                ExecutionResult result2 = ExecutionResult.failure(t);
                execution.record(result2);
                promise.complete(result2);
            }
            return promise;
        };
    }

    static <R> Supplier<CompletableFuture<ExecutionResult>> getPromiseOfStageExecution(AsyncSupplier<R, ? extends CompletionStage<? extends R>> supplier, AsyncExecution execution) {
        Assert.notNull(supplier, "supplier");
        Semaphore asyncFutureLock = new Semaphore(1);
        return () -> {
            try {
                execution.preExecute();
                asyncFutureLock.acquire();
                CompletionStage stage = (CompletionStage)supplier.get(execution);
                stage.whenComplete((innerResult, failure) -> {
                    try {
                        if (failure != null) {
                            execution.completeOrHandle(innerResult, failure instanceof CompletionException ? failure.getCause() : failure);
                        }
                    }
                    finally {
                        asyncFutureLock.release();
                    }
                });
            }
            catch (Throwable e) {
                try {
                    execution.completeOrHandle(null, e);
                }
                finally {
                    asyncFutureLock.release();
                }
            }
            return ExecutionResult.NULL_FUTURE;
        };
    }

    static <R> SettableSupplier<CompletableFuture<R>> toSettableSupplier(final Supplier<CompletableFuture<R>> supplier) {
        return new SettableSupplier<CompletableFuture<R>>(){
            volatile boolean called;
            volatile CompletableFuture<R> value;

            @Override
            public CompletableFuture<R> get() {
                if (!this.called && this.value != null) {
                    this.called = true;
                    return this.value;
                }
                return (CompletableFuture)supplier.get();
            }

            @Override
            public void set(CompletableFuture<R> value) {
                this.called = false;
                this.value = value;
            }
        };
    }

    static CheckedSupplier<Void> toSupplier(CheckedRunnable runnable) {
        Assert.notNull(runnable, "runnable");
        return () -> {
            runnable.run();
            return null;
        };
    }

    static CheckedSupplier<Void> toSupplier(ContextualRunnable runnable, ExecutionContext<Void> context) {
        Assert.notNull(runnable, "runnable");
        return () -> {
            runnable.run(context);
            return null;
        };
    }

    static <R> CheckedSupplier<R> toSupplier(ContextualSupplier<R, R> supplier, ExecutionContext<R> context) {
        Assert.notNull(supplier, "supplier");
        return () -> supplier.get(context);
    }

    static ContextualSupplier<Void, Void> toCtxSupplier(CheckedRunnable runnable) {
        Assert.notNull(runnable, "runnable");
        return ctx -> {
            runnable.run();
            return null;
        };
    }

    static ContextualSupplier<Void, Void> toCtxSupplier(ContextualRunnable runnable) {
        Assert.notNull(runnable, "runnable");
        return ctx -> {
            runnable.run(ctx);
            return null;
        };
    }

    static <R, T> ContextualSupplier<R, T> toCtxSupplier(CheckedSupplier<T> supplier) {
        Assert.notNull(supplier, "supplier");
        return ctx -> supplier.get();
    }

    static <T, R> CheckedFunction<T, R> toFn(CheckedConsumer<T> consumer) {
        return t -> {
            consumer.accept(t);
            return null;
        };
    }

    static <T, R> CheckedFunction<T, R> toFn(CheckedRunnable runnable) {
        return t -> {
            runnable.run();
            return null;
        };
    }

    static <T, R> CheckedFunction<T, R> toFn(CheckedSupplier<R> supplier) {
        return t -> supplier.get();
    }

    static <T, R> CheckedFunction<T, R> toFn(R result) {
        return t -> result;
    }

    private static /* synthetic */ Object lambda$null$3(Supplier supplier, CompletableFuture promise) throws Exception {
        return ((CompletableFuture)supplier.get()).whenComplete((result, error) -> {
            if (error != null) {
                promise.completeExceptionally((Throwable)error);
            } else {
                promise.complete(result);
            }
        });
    }

    static interface SettableSupplier<T>
    extends Supplier<T> {
        public void set(T var1);
    }
}

