/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.net.jodah.failsafe.internal;

import alluxio.shaded.client.net.jodah.failsafe.CircuitBreaker;
import alluxio.shaded.client.net.jodah.failsafe.ExecutionContext;
import alluxio.shaded.client.net.jodah.failsafe.internal.CircuitBreakerInternals;
import alluxio.shaded.client.net.jodah.failsafe.internal.CircuitState;
import alluxio.shaded.client.net.jodah.failsafe.internal.CircuitStats;

public class HalfOpenState
extends CircuitState {
    private final CircuitBreakerInternals internals;

    public HalfOpenState(CircuitBreaker breaker, CircuitBreakerInternals internals) {
        super(breaker, CircuitStats.create(breaker, HalfOpenState.capacityFor(breaker), false, null));
        this.internals = internals;
    }

    @Override
    public boolean allowsExecution() {
        return this.internals.getCurrentExecutions() < HalfOpenState.capacityFor(this.breaker);
    }

    @Override
    public CircuitBreaker.State getState() {
        return CircuitBreaker.State.HALF_OPEN;
    }

    @Override
    public synchronized void handleConfigChange() {
        this.stats = CircuitStats.create(this.breaker, HalfOpenState.capacityFor(this.breaker), false, this.stats);
    }

    @Override
    synchronized void checkThreshold(ExecutionContext context) {
        boolean failuresExceeded;
        boolean successesExceeded;
        int successThreshold = this.breaker.getSuccessThreshold();
        if (successThreshold != 0) {
            int successThresholdingCapacity = this.breaker.getSuccessThresholdingCapacity();
            successesExceeded = this.stats.getSuccessCount() >= successThreshold;
            failuresExceeded = this.stats.getFailureCount() > successThresholdingCapacity - successThreshold;
        } else {
            int failureRateThreshold = this.breaker.getFailureRateThreshold();
            if (failureRateThreshold != 0) {
                boolean executionThresholdExceeded = this.stats.getExecutionCount() >= this.breaker.getFailureExecutionThreshold();
                failuresExceeded = executionThresholdExceeded && this.stats.getFailureRate() >= failureRateThreshold;
                successesExceeded = executionThresholdExceeded && this.stats.getSuccessRate() > 100 - failureRateThreshold;
            } else {
                int failureThresholdingCapacity = this.breaker.getFailureThresholdingCapacity();
                int failureThreshold = this.breaker.getFailureThreshold();
                failuresExceeded = this.stats.getFailureCount() >= failureThreshold;
                boolean bl = successesExceeded = this.stats.getSuccessCount() > failureThresholdingCapacity - failureThreshold;
            }
        }
        if (successesExceeded) {
            this.breaker.close();
        } else if (failuresExceeded) {
            this.internals.open(context);
        }
    }

    private static int capacityFor(CircuitBreaker<?> breaker) {
        int capacity = breaker.getSuccessThresholdingCapacity();
        if (capacity == 0) {
            capacity = breaker.getFailureExecutionThreshold();
        }
        if (capacity == 0) {
            capacity = breaker.getFailureThresholdingCapacity();
        }
        return capacity;
    }
}

