/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.org.apache.zookeeper.server;

import alluxio.shaded.client.org.apache.yetus.audience.InterfaceAudience;
import alluxio.shaded.client.org.apache.zookeeper.jmx.ManagedUtil;
import alluxio.shaded.client.org.apache.zookeeper.server.ContainerManager;
import alluxio.shaded.client.org.apache.zookeeper.server.ServerCnxnFactory;
import alluxio.shaded.client.org.apache.zookeeper.server.ServerConfig;
import alluxio.shaded.client.org.apache.zookeeper.server.ZooKeeperServer;
import alluxio.shaded.client.org.apache.zookeeper.server.ZooKeeperServerShutdownHandler;
import alluxio.shaded.client.org.apache.zookeeper.server.admin.AdminServer;
import alluxio.shaded.client.org.apache.zookeeper.server.admin.AdminServerFactory;
import alluxio.shaded.client.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import alluxio.shaded.client.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class ZooKeeperServerMain {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperServerMain.class);
    private static final String USAGE = "Usage: ZooKeeperServerMain configfile | port datadir [ticktime] [maxcnxns]";
    private ServerCnxnFactory cnxnFactory;
    private ServerCnxnFactory secureCnxnFactory;
    private ContainerManager containerManager;
    private AdminServer adminServer;

    public static void main(String[] args) {
        ZooKeeperServerMain main = new ZooKeeperServerMain();
        try {
            main.initializeAndRun(args);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Invalid arguments, exiting abnormally", (Throwable)e);
            LOG.info(USAGE);
            System.err.println(USAGE);
            System.exit(2);
        }
        catch (QuorumPeerConfig.ConfigException e) {
            LOG.error("Invalid config, exiting abnormally", (Throwable)e);
            System.err.println("Invalid config, exiting abnormally");
            System.exit(2);
        }
        catch (FileTxnSnapLog.DatadirException e) {
            LOG.error("Unable to access datadir, exiting abnormally", (Throwable)e);
            System.err.println("Unable to access datadir, exiting abnormally");
            System.exit(3);
        }
        catch (AdminServer.AdminServerException e) {
            LOG.error("Unable to start AdminServer, exiting abnormally", (Throwable)e);
            System.err.println("Unable to start AdminServer, exiting abnormally");
            System.exit(4);
        }
        catch (Exception e) {
            LOG.error("Unexpected exception, exiting abnormally", (Throwable)e);
            System.exit(1);
        }
        LOG.info("Exiting normally");
        System.exit(0);
    }

    protected void initializeAndRun(String[] args) throws QuorumPeerConfig.ConfigException, IOException, AdminServer.AdminServerException {
        try {
            ManagedUtil.registerLog4jMBeans();
        }
        catch (JMException e) {
            LOG.warn("Unable to register log4j JMX control", (Throwable)e);
        }
        ServerConfig config = new ServerConfig();
        if (args.length == 1) {
            config.parse(args[0]);
        } else {
            config.parse(args);
        }
        this.runFromConfig(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runFromConfig(ServerConfig config) throws IOException, AdminServer.AdminServerException {
        LOG.info("Starting server");
        try (FileTxnSnapLog txnLog = null;){
            txnLog = new FileTxnSnapLog(config.dataLogDir, config.dataDir);
            ZooKeeperServer zkServer = new ZooKeeperServer(txnLog, config.tickTime, config.minSessionTimeout, config.maxSessionTimeout, null);
            txnLog.setServerStats(zkServer.serverStats());
            CountDownLatch shutdownLatch = new CountDownLatch(1);
            zkServer.registerServerShutdownHandler(new ZooKeeperServerShutdownHandler(shutdownLatch));
            this.adminServer = AdminServerFactory.createAdminServer();
            this.adminServer.setZooKeeperServer(zkServer);
            this.adminServer.start();
            boolean needStartZKServer = true;
            if (config.getClientPortAddress() != null) {
                this.cnxnFactory = ServerCnxnFactory.createFactory();
                this.cnxnFactory.configure(config.getClientPortAddress(), config.getMaxClientCnxns(), false);
                this.cnxnFactory.startup(zkServer);
                needStartZKServer = false;
            }
            if (config.getSecureClientPortAddress() != null) {
                this.secureCnxnFactory = ServerCnxnFactory.createFactory();
                this.secureCnxnFactory.configure(config.getSecureClientPortAddress(), config.getMaxClientCnxns(), true);
                this.secureCnxnFactory.startup(zkServer, needStartZKServer);
            }
            this.containerManager = new ContainerManager(zkServer.getZKDatabase(), zkServer.firstProcessor, Integer.getInteger("znode.container.checkIntervalMs", (int)TimeUnit.MINUTES.toMillis(1L)), Integer.getInteger("znode.container.maxPerMinute", 10000));
            this.containerManager.start();
            shutdownLatch.await();
            this.shutdown();
            if (this.cnxnFactory != null) {
                this.cnxnFactory.join();
            }
            if (this.secureCnxnFactory != null) {
                this.secureCnxnFactory.join();
            }
            if (zkServer.canShutdown()) {
                zkServer.shutdown(true);
            }
        }
    }

    protected void shutdown() {
        if (this.containerManager != null) {
            this.containerManager.stop();
        }
        if (this.cnxnFactory != null) {
            this.cnxnFactory.shutdown();
        }
        if (this.secureCnxnFactory != null) {
            this.secureCnxnFactory.shutdown();
        }
        try {
            if (this.adminServer != null) {
                this.adminServer.shutdown();
            }
        }
        catch (AdminServer.AdminServerException e) {
            LOG.warn("Problem stopping AdminServer", (Throwable)e);
        }
    }

    ServerCnxnFactory getCnxnFactory() {
        return this.cnxnFactory;
    }
}

