/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.network.tls;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.shaded.client.io.netty.handler.ssl.SslContext;
import alluxio.util.CommonUtils;

public interface SslContextProvider {
    public void init(AlluxioConfiguration var1);

    public SslContext getClientSslContext();

    public SslContext getServerSSLContext();

    public SslContext getSelfSignedClientSslContext();

    public SslContext getSelfSignedServerSslContext();

    public static class Factory {
        private Factory() {
        }

        public static SslContextProvider create(AlluxioConfiguration conf) {
            SslContextProvider provider = (SslContextProvider)CommonUtils.createNewClassInstance(conf.getClass(PropertyKey.NETWORK_TLS_SSL_CONTEXT_PROVIDER_CLASSNAME), null, null);
            provider.init(conf);
            return provider;
        }
    }
}

