/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.io;

import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.io.netty.buffer.ByteBuf;
import alluxio.shaded.client.io.netty.buffer.Unpooled;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.worker.block.io.BlockReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;

@ThreadSafe
public class BlockReadableChannel
implements ReadableByteChannel {
    private final BlockReader mReader;
    private volatile boolean mClosed = false;

    public BlockReadableChannel(BlockReader reader) {
        this.mReader = Preconditions.checkNotNull(reader, "reader");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.mClosed) {
            throw new ClosedChannelException();
        }
        int maxReadable = dst.remaining();
        int position = dst.position();
        BlockReadableChannel blockReadableChannel = this;
        synchronized (blockReadableChannel) {
            ByteBuf buf = Unpooled.wrappedBuffer(dst);
            buf.writerIndex(0);
            int bytesRead = this.mReader.transferTo(buf);
            Preconditions.checkState(bytesRead <= maxReadable, "buffer overflow");
            if (bytesRead > 0) {
                dst.position(position + bytesRead);
            }
            return bytesRead;
        }
    }

    @Override
    public boolean isOpen() {
        return !this.mClosed;
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
    }
}

