package alluxio.shaded.client.io.etcd.jetcd.api;

import static alluxio.shaded.client.io.etcd.jetcd.api.ElectionGrpc.getServiceDescriptor;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncBidiStreamingCall;


@alluxio.shaded.client.javax.annotation.Generated(
value = "by VertxGrpc generator",
alluxio.shaded.client.com.ents = "Source: election.proto")
public final class VertxElectionGrpc {
    private VertxElectionGrpc() {}

    public static ElectionVertxStub newVertxStub(alluxio.shaded.client.io.grpc.Channel channel) {
        return new ElectionVertxStub(channel);
    }

    /**
     * <pre>
     *  The election service exposes client-side election facilities as a gRPC interface.
     * </pre>
     */
    public static final class ElectionVertxStub extends alluxio.shaded.client.io.grpc.stub.AbstractStub<ElectionVertxStub> {
        private final alluxio.shaded.client.io.vertx.core.impl.ContextInternal ctx;
        private ElectionGrpc.ElectionStub delegateStub;

        private ElectionVertxStub(alluxio.shaded.client.io.grpc.Channel channel) {
            super(channel);
            delegateStub = ElectionGrpc.newStub(channel);
            this.ctx = (alluxio.shaded.client.io.vertx.core.impl.ContextInternal) alluxio.shaded.client.io.vertx.core.Vertx.currentContext();
        }

        private ElectionVertxStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
            delegateStub = ElectionGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (alluxio.shaded.client.io.vertx.core.impl.ContextInternal) alluxio.shaded.client.io.vertx.core.Vertx.currentContext();
        }

        @Override
        protected ElectionVertxStub build(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
            return new ElectionVertxStub(channel, callOptions);
        }

        /**
         * <pre>
         *  Campaign waits to acquire leadership in an election, returning a LeaderKey
         *  representing the leadership if successful. The LeaderKey can then be used
         *  to issue new values on the election, transactionally guard API requests on
         *  leadership still being held, and resign from the election.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.CampaignResponse> campaign(alluxio.shaded.client.io.etcd.jetcd.api.CampaignRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::campaign);
        }

        /**
         * <pre>
         *  Proclaim updates the leader&#39;s posted value with a new value.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.ProclaimResponse> proclaim(alluxio.shaded.client.io.etcd.jetcd.api.ProclaimRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::proclaim);
        }

        /**
         * <pre>
         *  Leader returns the current election proclamation, if any.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse> leader(alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::leader);
        }

        /**
         * <pre>
         *  Resign releases election leadership so other campaigners may acquire
         *  leadership on the election.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.ResignResponse> resign(alluxio.shaded.client.io.etcd.jetcd.api.ResignRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::resign);
        }

        /**
         * <pre>
         *  Observe streams election proclamations in-order as made by the election&#39;s
         *  elected leaders.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.streams.ReadStream<alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse> observe(alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToMany(ctx, request, delegateStub::observe);
        }

    }

    /**
     * <pre>
     *  The election service exposes client-side election facilities as a gRPC interface.
     * </pre>
     */
    public static abstract class ElectionVertxImplBase implements alluxio.shaded.client.io.grpc.BindableService {
        private String alluxio.shaded.client.com.ression;

        /**
         * Set whether the server will try to use a alluxio.shaded.client.com.ressed response.
         *
         * @param alluxio.shaded.client.com.ression the alluxio.shaded.client.com.ression, e.g {@code gzip}
         */
        public ElectionVertxImplBase withCompression(String alluxio.shaded.client.com.ression) {
            this.alluxio.shaded.client.com.ression = alluxio.shaded.client.com.ression;
            return this;
        }

        /**
         * <pre>
         *  Campaign waits to acquire leadership in an election, returning a LeaderKey
         *  representing the leadership if successful. The LeaderKey can then be used
         *  to issue new values on the election, transactionally guard API requests on
         *  leadership still being held, and resign from the election.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.CampaignResponse> campaign(alluxio.shaded.client.io.etcd.jetcd.api.CampaignRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Proclaim updates the leader&#39;s posted value with a new value.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.ProclaimResponse> proclaim(alluxio.shaded.client.io.etcd.jetcd.api.ProclaimRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Leader returns the current election proclamation, if any.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse> leader(alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Resign releases election leadership so other campaigners may acquire
         *  leadership on the election.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.ResignResponse> resign(alluxio.shaded.client.io.etcd.jetcd.api.ResignRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Observe streams election proclamations in-order as made by the election&#39;s
         *  elected leaders.
         * </pre>
         */
        public void observe(alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest request, alluxio.shaded.client.io.vertx.core.streams.WriteStream<alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse> response) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        @java.lang.Override public final alluxio.shaded.client.io.grpc.ServerServiceDefinition bindService() {
            return alluxio.shaded.client.io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.ElectionGrpc.getCampaignMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.CampaignRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.CampaignResponse>(
                                            this, METHODID_CAMPAIGN, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.ElectionGrpc.getProclaimMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.ProclaimRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.ProclaimResponse>(
                                            this, METHODID_PROCLAIM, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.ElectionGrpc.getLeaderMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse>(
                                            this, METHODID_LEADER, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.ElectionGrpc.getObserveMethod(),
                            asyncServerStreamingCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse>(
                                            this, METHODID_OBSERVE, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.ElectionGrpc.getResignMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.ResignRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.ResignResponse>(
                                            this, METHODID_RESIGN, alluxio.shaded.client.com.ression)))
                    .build();
        }
    }

    private static final int METHODID_CAMPAIGN = 0;
    private static final int METHODID_PROCLAIM = 1;
    private static final int METHODID_LEADER = 2;
    private static final int METHODID_OBSERVE = 3;
    private static final int METHODID_RESIGN = 4;

    private static final class MethodHandlers<Req, Resp> implements
            alluxio.shaded.client.io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
            alluxio.shaded.client.io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
            alluxio.shaded.client.io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
            alluxio.shaded.client.io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {

        private final ElectionVertxImplBase serviceImpl;
        private final int methodId;
        private final String alluxio.shaded.client.com.ression;

        MethodHandlers(ElectionVertxImplBase serviceImpl, int methodId, String alluxio.shaded.client.com.ression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.alluxio.shaded.client.com.ression = alluxio.shaded.client.com.ression;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public void invoke(Req request, alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_CAMPAIGN:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.CampaignRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.CampaignResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::campaign);
                    break;
                case METHODID_PROCLAIM:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.ProclaimRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.ProclaimResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::proclaim);
                    break;
                case METHODID_LEADER:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::leader);
                    break;
                case METHODID_OBSERVE:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToMany(
                            (alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::observe);
                    break;
                case METHODID_RESIGN:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.ResignRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.ResignResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::resign);
                    break;
                default:
                    throw new java.lang.AssertionError();
            }
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public alluxio.shaded.client.io.grpc.stub.StreamObserver<Req> invoke(alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                default:
                    throw new java.lang.AssertionError();
            }
        }
    }

}
