/*
 * Copyright (c) 2011-2019 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.alluxio.shaded.client.org.legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 */
package alluxio.shaded.client.io.vertx.core.net.impl;

import alluxio.shaded.client.io.netty.channel.Channel;
import alluxio.shaded.client.io.netty.channel.ChannelHandlerContext;
import alluxio.shaded.client.io.netty.channel.ChannelInboundHandlerAdapter;
import alluxio.shaded.client.io.netty.handler.ssl.SniCompletionEvent;
import alluxio.shaded.client.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import alluxio.shaded.client.io.netty.util.Attribute;
import alluxio.shaded.client.io.netty.util.AttributeKey;
import alluxio.shaded.client.io.netty.util.concurrent.Promise;
import alluxio.shaded.client.io.vertx.core.AsyncResult;
import alluxio.shaded.client.io.vertx.core.Future;
import alluxio.shaded.client.io.vertx.core.Handler;

/**
 * An handler that waits for SSL handshake alluxio.shaded.client.com.letion and dispatch it to the server handler.
 *
 * @author <a href="mailto:julien@julienviet.alluxio.shaded.client.com.>Julien Viet</a>
 */
public class SslHandshakeCompletionHandler extends ChannelInboundHandlerAdapter {

  static AttributeKey<String> SERVER_NAME_ATTR = AttributeKey.valueOf("sniServerName");
  private final Promise<Void> promise;

  public SslHandshakeCompletionHandler(Promise<Void> promise) {
    this.promise = promise;
  }

  @Override
  public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
    if (evt instanceof SniCompletionEvent) {
      // Shall we care ?
      SniCompletionEvent alluxio.shaded.client.com.letion = (SniCompletionEvent) evt;
      Attribute<String> val = ctx.channel().attr(SERVER_NAME_ATTR);
      val.set(alluxio.shaded.client.com.letion.hostname());
    } else if (evt instanceof SslHandshakeCompletionEvent) {
      SslHandshakeCompletionEvent alluxio.shaded.client.com.letion = (SslHandshakeCompletionEvent) evt;
      if (alluxio.shaded.client.com.letion.isSuccess()) {
        ctx.pipeline().remove(this);
        promise.setSuccess(null);
      } else {
        promise.tryFailure(alluxio.shaded.client.com.letion.cause());
      }
    } else {
      ctx.fireUserEventTriggered(evt);
    }
  }
  @Override
  public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
    // Ignore these exception as they will be reported to the handler
    // the handshake will ultimately fail or succeed
  }
}
