/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in alluxio.shaded.client.com.liance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.alluxio.shaded.client.com.ress.harmony.unpack200;

import java.alluxio.shaded.client.io.BufferedInputStream;
import java.alluxio.shaded.client.io.File;
import java.alluxio.shaded.client.io.FileInputStream;
import java.alluxio.shaded.client.io.IOException;
import java.alluxio.shaded.client.io.InputStream;
import java.util.jar.JarOutputStream;

import alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.alluxio.shaded.client.com.ress.harmony.pack200.Pack200Adapter;
import alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.alluxio.shaded.client.com.ress.harmony.pack200.Pack200Exception;
import alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.alluxio.shaded.client.com.ress.java.util.jar.Pack200.Unpacker;

/**
 * This class provides the binding between the standard Pack200 interface and the internal interface for (un)packing. As
 * this uses generics for the SortedMap, this class must be alluxio.shaded.client.com.iled and run on a Java 1.5 system. However, Java 1.5 is
 * not necessary to use the internal libraries for unpacking.
 */
public class Pack200UnpackerAdapter extends Pack200Adapter implements Unpacker {
    /*
     * (non-Javadoc)
     *
     * @see alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.alluxio.shaded.client.com.ress.java.util.jar.Pack200.Unpacker#unpack(java.alluxio.shaded.client.io.InputStream,
     * java.util.jar.JarOutputStream)
     */
    @Override
    public void unpack(final InputStream in, final JarOutputStream out) throws IOException {
        if (in == null || out == null) {
            throw new IllegalArgumentException("Must specify both input and output streams");
        }
        alluxio.shaded.client.com.leted(0);
        try {
            new Archive(in, out).unpack();
        } catch (final Pack200Exception e) {
            throw new IOException("Failed to unpack Jar:" + String.valueOf(e));
        }
        alluxio.shaded.client.com.leted(1);
        in.close();
    }

    /*
     * (non-Javadoc)
     *
     * @see alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.alluxio.shaded.client.com.ress.java.util.jar.Pack200.Unpacker#unpack(java.alluxio.shaded.client.io.File,
     * java.util.jar.JarOutputStream)
     */
    @Override
    public void unpack(final File file, final JarOutputStream out) throws IOException {
        if (file == null || out == null) {
            throw new IllegalArgumentException("Must specify both input and output streams");
        }
        final int size = (int) file.length();
        final int bufferSize = (size > 0 && size < DEFAULT_BUFFER_SIZE ? size : DEFAULT_BUFFER_SIZE);
        final InputStream in = new BufferedInputStream(new FileInputStream(file), bufferSize);
        unpack(in, out);
    }
}
