/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.security.user.UserState;
import alluxio.shaded.client.javax.security.auth.Subject;
import java.net.InetSocketAddress;
import java.util.Objects;

public class ClientContext {
    private volatile AlluxioConfiguration mClusterConf;
    private volatile String mClusterConfHash;
    private volatile UserState mUserState;
    private volatile boolean mUriValidationEnabled = true;

    public static ClientContext create(Subject subject, AlluxioConfiguration alluxioConf) {
        return new ClientContext(subject, alluxioConf);
    }

    public static ClientContext create(AlluxioConfiguration alluxioConf) {
        return new ClientContext(new Subject(), alluxioConf);
    }

    public static ClientContext create() {
        return new ClientContext(new Subject(), Configuration.global());
    }

    protected ClientContext(ClientContext ctx) {
        this.mClusterConf = ctx.getClusterConf();
        this.mUserState = ctx.getUserState();
        this.mClusterConfHash = ctx.getClusterConfHash();
        this.mUriValidationEnabled = ctx.getUriValidationEnabled();
    }

    protected ClientContext(Subject subject, AlluxioConfiguration alluxioConf) {
        Objects.requireNonNull(subject, "subject is null");
        this.mClusterConf = Objects.requireNonNull(alluxioConf, "alluxioConf is null");
        this.mClusterConfHash = alluxioConf.hash();
        this.mUserState = UserState.Factory.create(this.mClusterConf, subject);
    }

    public synchronized void loadConf(InetSocketAddress address) throws AlluxioStatusException {
    }

    public synchronized void loadConfIfNotLoaded(InetSocketAddress address) throws AlluxioStatusException {
        if (!this.mClusterConf.getBoolean(PropertyKey.USER_CONF_CLUSTER_DEFAULT_ENABLED)) {
            return;
        }
        this.mUserState = UserState.Factory.create(this.mClusterConf, this.mUserState.getSubject());
    }

    public ClientContext setUriValidationEnabled(boolean uriValidationEnabled) {
        this.mUriValidationEnabled = uriValidationEnabled;
        return this;
    }

    public boolean getUriValidationEnabled() {
        return this.mUriValidationEnabled;
    }

    public AlluxioConfiguration getClusterConf() {
        return this.mClusterConf;
    }

    protected void setClusterConf(AlluxioConfiguration alluxioConfiguration) {
        this.mClusterConf = alluxioConfiguration;
    }

    protected void setClusterConfHash(String clusterConfHash) {
        this.mClusterConfHash = clusterConfHash;
    }

    public String getClusterConfHash() {
        return this.mClusterConfHash;
    }

    public Subject getSubject() {
        return this.mUserState.getSubject();
    }

    public UserState getUserState() {
        return this.mUserState;
    }
}

