/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.dora;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.collect.ImmutableList;
import alluxio.shaded.client.com.google.common.hash.HashCode;
import alluxio.shaded.client.com.google.common.hash.HashFunction;
import alluxio.shaded.client.com.google.common.hash.Hashing;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.wire.WorkerIdentity;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;

@VisibleForTesting
@ThreadSafe
public class ConsistentHashProvider {
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_32_fixed();
    private final int mMaxAttempts;
    private final long mWorkerInfoUpdateIntervalNs;
    private final AtomicLong mLastUpdatedTimestamp = new AtomicLong(System.nanoTime());
    private final LongAdder mUpdateCount = new LongAdder();
    private final AtomicReference<List<BlockWorkerInfo>> mLastWorkerInfos = new AtomicReference(ImmutableList.of());
    @Nullable
    private volatile NavigableMap<Integer, BlockWorkerInfo> mActiveNodesByConsistentHashing;
    private final Object mInitLock = new Object();

    public ConsistentHashProvider(int maxAttempts, long workerListTtlMs) {
        this.mMaxAttempts = maxAttempts;
        this.mWorkerInfoUpdateIntervalNs = workerListTtlMs * 1000000L;
    }

    public List<BlockWorkerInfo> getMultiple(String key, int count) {
        LinkedHashSet<BlockWorkerInfo> workers = new LinkedHashSet<BlockWorkerInfo>();
        int attempts = 0;
        while (workers.size() < count && attempts < this.mMaxAttempts) {
            workers.add(this.get(key, ++attempts));
        }
        return ImmutableList.copyOf(workers);
    }

    public void refresh(List<BlockWorkerInfo> workerInfos, int numVirtualNodes) {
        Preconditions.checkArgument(!workerInfos.isEmpty(), "cannot refresh hash provider with empty worker list");
        this.maybeInitialize(workerInfos, numVirtualNodes);
        if (this.shouldRebuildActiveNodesMapExclusively() && this.hasWorkerListChanged(workerInfos, this.mLastWorkerInfos.get())) {
            this.mActiveNodesByConsistentHashing = ConsistentHashProvider.build(workerInfos, numVirtualNodes);
            this.mLastWorkerInfos.set(workerInfos);
            this.mUpdateCount.increment();
        }
    }

    private boolean shouldRebuildActiveNodesMapExclusively() {
        long lastUpdateTs = this.mLastUpdatedTimestamp.get();
        long currentTs = System.nanoTime();
        if (currentTs - lastUpdateTs > this.mWorkerInfoUpdateIntervalNs) {
            return this.mLastUpdatedTimestamp.compareAndSet(lastUpdateTs, currentTs);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeInitialize(List<BlockWorkerInfo> workerInfos, int numVirtualNodes) {
        if (this.mActiveNodesByConsistentHashing == null) {
            Object object = this.mInitLock;
            synchronized (object) {
                if (this.mActiveNodesByConsistentHashing == null) {
                    this.mActiveNodesByConsistentHashing = ConsistentHashProvider.build(workerInfos, numVirtualNodes);
                    this.mLastWorkerInfos.set(workerInfos);
                    this.mLastUpdatedTimestamp.set(System.nanoTime());
                }
            }
        }
    }

    private boolean hasWorkerListChanged(List<BlockWorkerInfo> workerInfoList, List<BlockWorkerInfo> anotherWorkerInfoList) {
        Set anotherWorkerAddressSet;
        if (workerInfoList == anotherWorkerInfoList) {
            return false;
        }
        Set workerAddressSet = workerInfoList.stream().map(BlockWorkerInfo::getIdentity).collect(Collectors.toSet());
        return !workerAddressSet.equals(anotherWorkerAddressSet = anotherWorkerInfoList.stream().map(BlockWorkerInfo::getIdentity).collect(Collectors.toSet()));
    }

    @VisibleForTesting
    BlockWorkerInfo get(String key, int index) {
        NavigableMap<Integer, BlockWorkerInfo> map = this.mActiveNodesByConsistentHashing;
        Preconditions.checkState(map != null, "Hash provider is not properly initialized");
        return ConsistentHashProvider.get(map, key, index);
    }

    @VisibleForTesting
    static BlockWorkerInfo get(NavigableMap<Integer, BlockWorkerInfo> map, String key, int index) {
        HashCode hashCode = HASH_FUNCTION.newHasher().putString(key, StandardCharsets.UTF_8).putInt(index).hash();
        int hashKey = hashCode.asInt();
        Map.Entry<Integer, BlockWorkerInfo> entry = map.ceilingEntry(hashKey);
        if (entry != null) {
            return entry.getValue();
        }
        Map.Entry<Integer, BlockWorkerInfo> firstEntry = map.firstEntry();
        if (firstEntry == null) {
            throw new IllegalStateException("Hash provider is empty");
        }
        return firstEntry.getValue();
    }

    @VisibleForTesting
    List<BlockWorkerInfo> getLastWorkerInfos() {
        return this.mLastWorkerInfos.get();
    }

    @VisibleForTesting
    NavigableMap<Integer, BlockWorkerInfo> getActiveNodesMap() {
        return this.mActiveNodesByConsistentHashing;
    }

    @VisibleForTesting
    long getUpdateCount() {
        return this.mUpdateCount.sum();
    }

    @VisibleForTesting
    static NavigableMap<Integer, BlockWorkerInfo> build(List<BlockWorkerInfo> workerInfos, int numVirtualNodes) {
        Preconditions.checkArgument(!workerInfos.isEmpty(), "worker list is empty");
        TreeMap<Integer, BlockWorkerInfo> activeNodesByConsistentHashing = new TreeMap<Integer, BlockWorkerInfo>();
        for (BlockWorkerInfo workerInfo : workerInfos) {
            for (int i = 0; i < numVirtualNodes; ++i) {
                HashCode hashCode = HASH_FUNCTION.newHasher().putObject(workerInfo.getIdentity(), WorkerIdentity.HashFunnel.INSTANCE).putInt(i).hash();
                activeNodesByConsistentHashing.put(hashCode.asInt(), workerInfo);
            }
        }
        return activeNodesByConsistentHashing;
    }
}

