/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.dora;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.ResourceExhaustedException;
import alluxio.util.CommonUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface WorkerLocationPolicy {
    public List<BlockWorkerInfo> getPreferredWorkers(List<BlockWorkerInfo> var1, String var2, int var3) throws ResourceExhaustedException;

    public static class Factory {
        private static final Logger LOG = LoggerFactory.getLogger(Factory.class);

        private Factory() {
        }

        public static WorkerLocationPolicy create(AlluxioConfiguration conf) {
            try {
                WorkerLocationPolicy workerLocationPolicy = (WorkerLocationPolicy)CommonUtils.createNewClassInstance(conf.getClass(PropertyKey.USER_WORKER_SELECTION_POLICY), new Class[]{AlluxioConfiguration.class}, new Object[]{conf});
                LOG.debug("Using worker location policy: {}", (Object)workerLocationPolicy.getClass().getSimpleName());
                return workerLocationPolicy;
            }
            catch (ClassCastException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

