/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.grpc.ClientVersionClientInjector;
import alluxio.grpc.GrpcChannel;
import alluxio.grpc.GrpcChannelPool;
import alluxio.grpc.GrpcNetworkGroup;
import alluxio.grpc.GrpcServerAddress;
import alluxio.security.authentication.AuthType;
import alluxio.shaded.client.javax.security.auth.Subject;

public class GrpcChannelBuilder {
    private final GrpcServerAddress mAddress;
    private final AlluxioConfiguration mConfiguration;
    private Subject mParentSubject;
    private AuthType mAuthType;
    private boolean mAlwaysEnableTLS;
    private GrpcNetworkGroup mNetworkGroup = GrpcNetworkGroup.RPC;

    private GrpcChannelBuilder(GrpcServerAddress address, AlluxioConfiguration conf) {
        this(address, conf, conf.getEnum(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.class), false);
    }

    protected GrpcChannelBuilder(GrpcServerAddress address, AlluxioConfiguration conf, AuthType authType, boolean alwaysEnableTLS) {
        this.mAddress = address;
        this.mConfiguration = conf;
        this.mAuthType = authType;
        this.mAlwaysEnableTLS = alwaysEnableTLS;
    }

    public static GrpcChannelBuilder newBuilder(GrpcServerAddress address, AlluxioConfiguration conf) {
        return new GrpcChannelBuilder(address, conf);
    }

    public static GrpcChannelBuilder newBuilder(GrpcServerAddress address, AlluxioConfiguration conf, boolean alwaysEnableTLS) {
        return new GrpcChannelBuilder(address, conf, conf.getEnum(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.class), alwaysEnableTLS);
    }

    public static GrpcChannelBuilder newBuilder(GrpcServerAddress address, AlluxioConfiguration conf, AuthType authType, boolean alwaysEnableTLS) {
        return new GrpcChannelBuilder(address, conf, authType, alwaysEnableTLS);
    }

    public GrpcChannelBuilder setSubject(Subject subject) {
        this.mParentSubject = subject;
        return this;
    }

    public GrpcChannelBuilder disableAuthentication() {
        this.mAuthType = AuthType.NOSASL;
        return this;
    }

    public GrpcChannelBuilder setNetworkGroup(GrpcNetworkGroup group) {
        this.mNetworkGroup = group;
        return this;
    }

    protected GrpcServerAddress getAddress() {
        return this.mAddress;
    }

    protected GrpcNetworkGroup getNetworkGroup() {
        return this.mNetworkGroup;
    }

    protected AlluxioConfiguration getConfiguration() {
        return this.mConfiguration;
    }

    protected boolean getAlwaysEnableTLS() {
        return this.mAlwaysEnableTLS;
    }

    protected AuthType getAuthType() {
        return this.mAuthType;
    }

    protected Subject getParentSubject() {
        return this.mParentSubject;
    }

    public GrpcChannel build() throws AlluxioStatusException {
        GrpcChannel channel = GrpcChannelPool.INSTANCE.acquireChannel(this.mNetworkGroup, this.mAddress, this.mConfiguration, this.mAlwaysEnableTLS);
        try {
            channel.authenticate(this.mAuthType, this.mParentSubject, this.mConfiguration);
        }
        catch (Throwable t) {
            try {
                channel.close();
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to release the connection: %s", channel.getChannelKey()), e);
            }
            if (t instanceof AlluxioStatusException) {
                throw t;
            }
            throw AlluxioStatusException.fromThrowable(t);
        }
        if (this.mConfiguration.getBoolean(PropertyKey.USER_CLIENT_REPORT_VERSION_ENABLED)) {
            channel.intercept(new ClientVersionClientInjector());
        }
        return channel;
    }
}

