/*
 * Decompiled with CFR 0.152.
 */
package alluxio.membership;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.membership.AlluxioEtcdClient;
import alluxio.membership.MembershipManager;
import alluxio.membership.WorkerServiceEntity;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.gson.JsonParseException;
import alluxio.shaded.client.com.google.gson.JsonSyntaxException;
import alluxio.shaded.client.io.etcd.jetcd.KeyValue;
import alluxio.util.CommonUtils;
import alluxio.wire.WorkerInfo;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdMembershipManager
implements MembershipManager {
    private static final Logger LOG = LoggerFactory.getLogger(EtcdMembershipManager.class);
    private final AlluxioConfiguration mConf;
    private AlluxioEtcdClient mAlluxioEtcdClient;
    private String mClusterName;
    private Supplier<String> mRingPathPrefix = CommonUtils.memoize(this::constructRingPathPrefix);

    public static EtcdMembershipManager create(AlluxioConfiguration conf) {
        return new EtcdMembershipManager(conf);
    }

    public EtcdMembershipManager(AlluxioConfiguration conf) {
        this(conf, AlluxioEtcdClient.getInstance(conf));
    }

    public EtcdMembershipManager(AlluxioConfiguration conf, AlluxioEtcdClient alluxioEtcdClient) {
        this.mConf = conf;
        this.mClusterName = conf.getString(PropertyKey.ALLUXIO_CLUSTER_NAME);
        this.mAlluxioEtcdClient = alluxioEtcdClient;
    }

    private String constructRingPathPrefix() {
        return String.format("/DHT/%s/AUTHORIZED/", this.mClusterName);
    }

    private String getRingPathPrefix() {
        return this.mRingPathPrefix.get();
    }

    @Override
    public void join(WorkerInfo workerInfo) throws IOException {
        LOG.info("Try joining on etcd for worker:{} ", (Object)workerInfo);
        WorkerServiceEntity entity = new WorkerServiceEntity(workerInfo.getIdentity(), workerInfo.getAddress());
        String pathOnRing = new StringBuffer().append(this.getRingPathPrefix()).append(entity.getServiceEntityName()).toString();
        byte[] existingEntityBytes = this.mAlluxioEtcdClient.getForPath(pathOnRing);
        byte[] serializedEntity = entity.serialize();
        if (existingEntityBytes != null) {
            if (!Arrays.equals(existingEntityBytes, serializedEntity)) {
                WorkerServiceEntity existingEntity = new WorkerServiceEntity();
                existingEntity.deserialize(existingEntityBytes);
                LOG.warn("Same worker entity found bearing same workerid:{},existing WorkerServiceEntity to be overwritten:{},maybe benign if pod restart in k8s env or same worker scheduled to restart on another machine in baremetal env.", (Object)workerInfo.getIdentity().toString(), (Object)existingEntity);
                this.mAlluxioEtcdClient.createForPath(pathOnRing, Optional.of(serializedEntity));
            }
        } else {
            this.mAlluxioEtcdClient.createForPath(pathOnRing, Optional.of(serializedEntity));
        }
        this.mAlluxioEtcdClient.mServiceDiscovery.registerAndStartSync(entity);
        LOG.info("Joined on etcd for worker:{} ", (Object)workerInfo);
    }

    @Override
    public List<WorkerInfo> getAllMembers() throws IOException {
        List<WorkerServiceEntity> registeredWorkers = this.retrieveFullMembers();
        return registeredWorkers.stream().map(e -> new WorkerInfo().setIdentity(e.getIdentity()).setAddress(e.getWorkerNetAddress())).collect(Collectors.toList());
    }

    private List<WorkerServiceEntity> retrieveFullMembers() throws IOException {
        ArrayList<WorkerServiceEntity> fullMembers = new ArrayList<WorkerServiceEntity>();
        List<KeyValue> childrenKvs = this.mAlluxioEtcdClient.getChildren(this.getRingPathPrefix());
        for (KeyValue kv : childrenKvs) {
            try {
                WorkerServiceEntity entity = new WorkerServiceEntity();
                entity.deserialize(kv.getValue().getBytes());
                fullMembers.add(entity);
            }
            catch (JsonParseException jsonParseException) {}
        }
        return fullMembers;
    }

    private List<WorkerServiceEntity> retrieveLiveMembers() throws IOException {
        ArrayList<WorkerServiceEntity> liveMembers = new ArrayList<WorkerServiceEntity>();
        for (Map.Entry<String, ByteBuffer> entry : this.mAlluxioEtcdClient.mServiceDiscovery.getAllLiveServices().entrySet()) {
            try {
                WorkerServiceEntity entity = new WorkerServiceEntity();
                entity.deserialize(entry.getValue().array());
                liveMembers.add(entity);
            }
            catch (JsonSyntaxException jsonSyntaxException) {}
        }
        return liveMembers;
    }

    @Override
    @VisibleForTesting
    public List<WorkerInfo> getLiveMembers() throws IOException {
        List<WorkerServiceEntity> liveWorkers = this.retrieveLiveMembers();
        return liveWorkers.stream().map(e -> new WorkerInfo().setIdentity(e.getIdentity()).setAddress(e.getWorkerNetAddress())).collect(Collectors.toList());
    }

    @Override
    @VisibleForTesting
    public List<WorkerInfo> getFailedMembers() throws IOException {
        List<WorkerServiceEntity> registeredWorkers = this.retrieveFullMembers();
        List liveWorkers = this.retrieveLiveMembers().stream().map(e -> e.getServiceEntityName()).collect(Collectors.toList());
        registeredWorkers.removeIf(e -> liveWorkers.contains(e.getServiceEntityName()));
        return registeredWorkers.stream().map(e -> new WorkerInfo().setIdentity(e.getIdentity()).setAddress(e.getWorkerNetAddress())).collect(Collectors.toList());
    }

    @Override
    @VisibleForTesting
    public String showAllMembers() {
        try {
            List<WorkerServiceEntity> registeredWorkers = this.retrieveFullMembers();
            List liveWorkers = this.retrieveLiveMembers().stream().map(w -> w.getServiceEntityName()).collect(Collectors.toList());
            String printFormat = "%s\t%s\t%s%n";
            StringBuilder sb = new StringBuilder(String.format(printFormat, "WorkerId", "Address", "Status"));
            for (WorkerServiceEntity entity : registeredWorkers) {
                String entryLine = String.format(printFormat, entity.getServiceEntityName(), entity.getWorkerNetAddress().getHost() + ":" + entity.getWorkerNetAddress().getRpcPort(), liveWorkers.contains(entity.getServiceEntityName()) ? "ONLINE" : "OFFLINE");
                sb.append(entryLine);
            }
            return sb.toString();
        }
        catch (IOException ex) {
            return String.format("Exception happened:%s", ex.getMessage());
        }
    }

    @Override
    public void stopHeartBeat(WorkerInfo worker) throws IOException {
        WorkerServiceEntity entity = new WorkerServiceEntity(worker.getIdentity(), worker.getAddress());
        this.mAlluxioEtcdClient.mServiceDiscovery.unregisterService(entity.getServiceEntityName());
    }

    @Override
    public void decommission(WorkerInfo worker) throws IOException {
    }

    @Override
    public void close() throws Exception {
    }
}

