/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication.plain;

import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.security.authentication.AuthenticationProvider;
import alluxio.security.authentication.ImpersonationAuthenticator;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.security.auth.callback.Callback;
import alluxio.shaded.client.javax.security.auth.callback.CallbackHandler;
import alluxio.shaded.client.javax.security.auth.callback.NameCallback;
import alluxio.shaded.client.javax.security.auth.callback.PasswordCallback;
import alluxio.shaded.client.javax.security.auth.callback.UnsupportedCallbackException;
import alluxio.shaded.client.javax.security.sasl.AuthorizeCallback;
import java.io.IOException;

public final class PlainSaslServerCallbackHandler
implements CallbackHandler {
    private final AuthenticationProvider mAuthenticationProvider;
    private final ImpersonationAuthenticator mImpersonationAuthenticator;

    public PlainSaslServerCallbackHandler(AuthenticationProvider authenticationProvider, ImpersonationAuthenticator authenticator) {
        this.mAuthenticationProvider = Preconditions.checkNotNull(authenticationProvider, "authenticationProvider");
        this.mImpersonationAuthenticator = authenticator;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        String username = null;
        String password = null;
        AuthorizeCallback ac = null;
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                NameCallback nc = (NameCallback)callback;
                username = nc.getName();
                continue;
            }
            if (callback instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callback;
                password = new String(pc.getPassword());
                continue;
            }
            if (callback instanceof AuthorizeCallback) {
                ac = (AuthorizeCallback)callback;
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unsupport callback");
        }
        this.mAuthenticationProvider.authenticate(username, password);
        if (ac != null) {
            ac.setAuthorized(true);
            try {
                this.mImpersonationAuthenticator.authenticate(username, ac.getAuthorizedID());
            }
            catch (Exception e) {
                ac.setAuthorized(false);
                throw e;
            }
            AuthenticatedClientUser.set(ac.getAuthorizedID());
        }
    }
}

