/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.user;

import alluxio.annotation.SuppressFBWarnings;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.UnauthenticatedException;
import alluxio.security.User;
import alluxio.security.authentication.AuthType;
import alluxio.security.user.NoopUserState;
import alluxio.security.user.SimpleUserState;
import alluxio.security.user.UserStateFactory;
import alluxio.shaded.client.javax.security.auth.Subject;
import alluxio.util.CommonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface UserState {
    @SuppressFBWarnings(value={"MS_OOI_PKGPROTECT"})
    public static final ArrayList<UserStateFactory> FACTORIES = new ArrayList<UserStateFactory>(Arrays.asList(new SimpleUserState.Factory(), new NoopUserState.Factory()));

    public Subject getSubject();

    public User getUser() throws UnauthenticatedException;

    public User relogin() throws UnauthenticatedException;

    default public void update(UserState otherUserState) throws IOException {
    }

    public static class Factory {
        private static final Logger LOG = LoggerFactory.getLogger(Factory.class);

        public static UserState create(AlluxioConfiguration conf) {
            return Factory.create(conf, new Subject());
        }

        public static UserState create(AlluxioConfiguration conf, Subject subject) {
            return Factory.create(conf, subject, CommonUtils.PROCESS_TYPE.get());
        }

        public static UserState create(AlluxioConfiguration conf, Subject subject, CommonUtils.ProcessType processType) {
            AuthType authType = conf.getEnum(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.class);
            boolean isServer = !processType.equals((Object)CommonUtils.ProcessType.CLIENT);
            for (UserStateFactory factory2 : FACTORIES) {
                UserState subjectState = factory2.create(subject, conf, isServer);
                if (subjectState == null) continue;
                return subjectState;
            }
            throw new UnsupportedOperationException("No factory could create a UserState with authType: " + (Object)((Object)authType) + ". factories: " + String.join((CharSequence)", ", FACTORIES.stream().map(factory -> factory.getClass().getName()).collect(Collectors.toList())));
        }
    }
}

