/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.amazonaws.jmx;

import alluxio.shaded.client.com.amazonaws.jmx.MBeans;
import alluxio.shaded.client.com.amazonaws.jmx.SdkMBeanRegistrySupport;
import alluxio.shaded.client.com.amazonaws.jmx.spi.JmxInfoProvider;
import alluxio.shaded.client.javax.management.Attribute;
import alluxio.shaded.client.javax.management.AttributeList;
import alluxio.shaded.client.javax.management.MBeanServer;
import alluxio.shaded.client.javax.management.ObjectName;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.List;
import org.apache.commons.logging.LogFactory;

public class JmxInfoProviderSupport
implements JmxInfoProvider {
    @Override
    public long[] getFileDecriptorInfo() {
        MBeanServer mbsc = MBeans.getMBeanServer();
        try {
            AttributeList attributes = mbsc.getAttributes(new ObjectName("java.lang:type=OperatingSystem"), new String[]{"OpenFileDescriptorCount", "MaxFileDescriptorCount"});
            List attrList = attributes.asList();
            long openFdCount = (Long)((Attribute)attrList.get(0)).getValue();
            long maxFdCount = (Long)((Attribute)attrList.get(1)).getValue();
            long[] fdCounts = new long[]{openFdCount, maxFdCount};
            return fdCounts;
        }
        catch (Exception e) {
            LogFactory.getLog(SdkMBeanRegistrySupport.class).debug((Object)"Failed to retrieve file descriptor info", (Throwable)e);
            return null;
        }
    }

    @Override
    public int getThreadCount() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        return threadMXBean.getThreadCount();
    }

    @Override
    public int getDaemonThreadCount() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        return threadMXBean.getDaemonThreadCount();
    }

    @Override
    public int getPeakThreadCount() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        return threadMXBean.getPeakThreadCount();
    }

    @Override
    public long getTotalStartedThreadCount() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        return threadMXBean.getTotalStartedThreadCount();
    }

    @Override
    public long[] findDeadlockedThreads() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        return threadMXBean.findDeadlockedThreads();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

