/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.amazonaws.jmx;

import alluxio.shaded.client.javax.management.InstanceAlreadyExistsException;
import alluxio.shaded.client.javax.management.InstanceNotFoundException;
import alluxio.shaded.client.javax.management.MBeanRegistrationException;
import alluxio.shaded.client.javax.management.MBeanServer;
import alluxio.shaded.client.javax.management.MBeanServerFactory;
import alluxio.shaded.client.javax.management.MalformedObjectNameException;
import alluxio.shaded.client.javax.management.NotCompliantMBeanException;
import alluxio.shaded.client.javax.management.ObjectName;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import org.apache.commons.logging.LogFactory;

public enum MBeans {


    public static <T> boolean registerMBean(String objectName, T mbean) throws MBeanRegistrationException {
        MBeanServer server = MBeans.getMBeanServer();
        try {
            server.registerMBean(mbean, new ObjectName(objectName));
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NotCompliantMBeanException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InstanceAlreadyExistsException e) {
            LogFactory.getLog(MBeans.class).debug((Object)("Failed to register mbean " + objectName), (Throwable)e);
            return false;
        }
        return true;
    }

    public static <T> boolean unregisterMBean(String objectName) throws MBeanRegistrationException {
        MBeanServer server = MBeans.getMBeanServer();
        try {
            server.unregisterMBean(new ObjectName(objectName));
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InstanceNotFoundException e) {
            LogFactory.getLog(MBeans.class).debug((Object)("Failed to unregister mbean " + objectName), (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean isRegistered(String objectName) {
        MBeanServer server = MBeans.getMBeanServer();
        try {
            return server.isRegistered(new ObjectName(objectName));
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static MBeanServer getMBeanServer() {
        ArrayList servers = MBeanServerFactory.findMBeanServer(null);
        MBeanServer server = servers.size() > 0 ? (MBeanServer)servers.get(0) : ManagementFactory.getPlatformMBeanServer();
        return server;
    }
}

