/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.codahale.metrics.jvm;

import alluxio.shaded.client.com.codahale.metrics.Gauge;
import alluxio.shaded.client.javax.management.JMException;
import alluxio.shaded.client.javax.management.MBeanServerConnection;
import alluxio.shaded.client.javax.management.ObjectName;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Set;

public class JmxAttributeGauge
implements Gauge<Object> {
    private final MBeanServerConnection mBeanServerConn;
    private final ObjectName objectName;
    private final String attributeName;

    public JmxAttributeGauge(ObjectName objectName, String attributeName) {
        this((MBeanServerConnection)ManagementFactory.getPlatformMBeanServer(), objectName, attributeName);
    }

    public JmxAttributeGauge(MBeanServerConnection mBeanServerConn, ObjectName objectName, String attributeName) {
        this.mBeanServerConn = mBeanServerConn;
        this.objectName = objectName;
        this.attributeName = attributeName;
    }

    @Override
    public Object getValue() {
        try {
            return this.mBeanServerConn.getAttribute(this.getObjectName(), this.attributeName);
        }
        catch (JMException | IOException e) {
            return null;
        }
    }

    private ObjectName getObjectName() throws IOException {
        Set foundNames;
        if (this.objectName.isPattern() && (foundNames = this.mBeanServerConn.queryNames(this.objectName, null)).size() == 1) {
            return (ObjectName)foundNames.iterator().next();
        }
        return this.objectName;
    }
}

