/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.AlluxioURI;
import alluxio.grpc.UfsStatus;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.underfs.UfsDirectoryStatus;
import alluxio.underfs.UfsFileStatus;
import alluxio.util.CommonUtils;
import java.util.HashMap;
import java.util.Map;

@NotThreadSafe
public abstract class UfsStatus {
    protected final boolean mIsDirectory;
    protected final Long mLastModifiedTimeMs;
    protected String mName;
    protected AlluxioURI mUfsFullPath;
    protected final String mOwner;
    protected final String mGroup;
    protected final short mMode;
    protected final Map<String, byte[]> mXAttr;

    public AlluxioURI getUfsFullPath() {
        return this.mUfsFullPath;
    }

    public void setUfsFullPath(AlluxioURI ufsFullPath) {
        this.mUfsFullPath = ufsFullPath;
    }

    protected UfsStatus(String name, boolean isDirectory, String owner, String group, short mode, @Nullable Long lastModifiedTimeMs, @Nullable Map<String, byte[]> xAttrs) {
        this.mIsDirectory = isDirectory;
        this.mName = name;
        this.mOwner = owner;
        this.mGroup = group;
        this.mMode = mode;
        this.mLastModifiedTimeMs = lastModifiedTimeMs;
        this.mXAttr = xAttrs;
    }

    protected UfsStatus(UfsStatus status) {
        this.mIsDirectory = status.mIsDirectory;
        this.mName = status.mName;
        this.mOwner = status.mOwner;
        this.mGroup = status.mGroup;
        this.mMode = status.mMode;
        this.mLastModifiedTimeMs = status.mLastModifiedTimeMs;
        this.mXAttr = status.mXAttr == null ? null : new HashMap<String, byte[]>(status.mXAttr);
    }

    public abstract UfsStatus copy();

    @Nullable
    public static String[] convertToNames(UfsStatus[] children) {
        if (children == null) {
            return null;
        }
        String[] ret = new String[children.length];
        for (int i = 0; i < children.length; ++i) {
            ret[i] = children[i].getName();
        }
        return ret;
    }

    public boolean isDirectory() {
        return this.mIsDirectory;
    }

    public boolean isFile() {
        return !this.mIsDirectory;
    }

    public String getGroup() {
        return this.mGroup;
    }

    @Nullable
    public Long getLastModifiedTime() {
        return this.mLastModifiedTimeMs;
    }

    public short getMode() {
        return this.mMode;
    }

    public String getName() {
        return this.mName;
    }

    public String getOwner() {
        return this.mOwner;
    }

    @Nullable
    public Map<String, byte[]> getXAttr() {
        return this.mXAttr;
    }

    public int hashCode() {
        return Objects.hashCode(this.mName, this.mIsDirectory, this.mOwner, this.mGroup, this.mMode, this.mXAttr);
    }

    public UfsStatus setName(String name) {
        this.mName = name;
        return this;
    }

    protected MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper(this).add("isDirectory", this.mIsDirectory).add("lastModifiedTimeMs", this.mLastModifiedTimeMs).add("name", this.mName).add("owner", this.mOwner).add("group", this.mGroup).add("mode", this.mMode).add("xAttr", this.mXAttr).add("ufsFullPath", this.mUfsFullPath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UfsStatus)) {
            return false;
        }
        UfsStatus that = (UfsStatus)o;
        return Objects.equal(this.mName, that.mName) && Objects.equal(this.mIsDirectory, that.mIsDirectory) && Objects.equal(this.mOwner, that.mOwner) && Objects.equal(this.mGroup, that.mGroup) && Objects.equal(this.mMode, that.mMode) && Objects.equal(this.mXAttr, that.mXAttr) && Objects.equal(this.mUfsFullPath, that.mUfsFullPath);
    }

    public alluxio.grpc.UfsStatus toProto() {
        UfsStatus.Builder builder = alluxio.grpc.UfsStatus.newBuilder();
        builder.setName(this.getName());
        builder.setIsDirectory(this.isDirectory());
        if (this.mLastModifiedTimeMs != null) {
            builder.setLastModifiedTimeMs(this.mLastModifiedTimeMs);
        }
        builder.setOwner(this.mOwner);
        builder.setGroup(this.mGroup);
        builder.setMode(this.mMode);
        if (this.mXAttr != null) {
            builder.putAllXattr(CommonUtils.convertToByteString(this.mXAttr));
        }
        if (this.mUfsFullPath != null) {
            builder.setUfsFullPath(this.mUfsFullPath.toString());
        }
        if (this instanceof UfsFileStatus) {
            builder.setUfsFileStatus(alluxio.grpc.UfsFileStatus.newBuilder().setBlockSize(((UfsFileStatus)this).getBlockSize()).setContentHash(((UfsFileStatus)this).getContentHash()).setContentLength(((UfsFileStatus)this).getContentLength()).build());
        }
        return builder.build();
    }

    public static UfsStatus fromProto(alluxio.grpc.UfsStatus ufsStatus) {
        UfsStatus status = ufsStatus.getIsDirectory() ? new UfsDirectoryStatus(ufsStatus.getName(), ufsStatus.getOwner(), ufsStatus.getGroup(), (short)ufsStatus.getMode(), ufsStatus.hasLastModifiedTimeMs() ? Long.valueOf(ufsStatus.getLastModifiedTimeMs()) : null, CommonUtils.convertFromByteString(ufsStatus.getXattrMap())) : new UfsFileStatus(ufsStatus.getName(), ufsStatus.getUfsFileStatus().getContentHash(), ufsStatus.getUfsFileStatus().getContentLength(), ufsStatus.hasLastModifiedTimeMs() ? Long.valueOf(ufsStatus.getLastModifiedTimeMs()) : null, ufsStatus.getOwner(), ufsStatus.getGroup(), (short)ufsStatus.getMode(), CommonUtils.convertFromByteString(ufsStatus.getXattrMap()), ufsStatus.getUfsFileStatus().getBlockSize());
        if (ufsStatus.hasUfsFullPath()) {
            status.setUfsFullPath(new AlluxioURI(ufsStatus.getUfsFullPath()));
        }
        return status;
    }

    public UfsFileStatus asUfsFileStatus() {
        return (UfsFileStatus)this;
    }
}

