/*
 * Copyright 2011 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in alluxio.shaded.client.com.liance
 * with the License. You may obtain a copy of the License at:
 *
 * https://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package alluxio.shaded.client.com.sun.nio.sctp;

import java.net.SocketAddress;

@SuppressWarnings("all")
public class SctpStandardSocketOptions {
    static {
        UnsupportedOperatingSystemException.raise();
    }

    public static final SctpSocketOption<Boolean> SCTP_DISABLE_FRAGMENTS = null;
    public static final SctpSocketOption<Boolean> SCTP_EXPLICIT_COMPLETE = null;
    public static final SctpSocketOption<Integer> SCTP_FRAGMENT_INTERLEAVE = null;
    public static final SctpSocketOption<InitMaxStreams> SCTP_INIT_MAXSTREAMS = null;
    public static final SctpSocketOption<Boolean> SCTP_NODELAY = null;
    public static final SctpSocketOption<SocketAddress> SCTP_PRIMARY_ADDR = null;
    public static final SctpSocketOption<SocketAddress> SCTP_SET_PEER_PRIMARY_ADDR = null;
    public static final SctpSocketOption<Integer> SO_LINGER = null;
    public static final SctpSocketOption<Integer> SO_RCVBUF = null;
    public static final SctpSocketOption<Integer> SO_SNDBUF = null;

    public static class InitMaxStreams {

        public static InitMaxStreams create(int i, int i1) {
            return null;
        }

        public int maxInStreams() {
            return 0;
        }

        public int maxOutStreams() {
            return 0;
        }

    }
}
