/*
 * Copyright 2016-2021 The jetcd authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.io.etcd.jetcd.lease;

import alluxio.shaded.client.io.etcd.jetcd.impl.AbstractResponse;

public class LeaseGrantResponse extends AbstractResponse<alluxio.shaded.client.io.etcd.jetcd.api.LeaseGrantResponse> {

    public LeaseGrantResponse(alluxio.shaded.client.io.etcd.jetcd.api.LeaseGrantResponse response) {
        super(response, response.getHeader());
    }

    /**
     * Returns the lease ID for the granted lease.
     *
     * @return the id.
     */
    public long getID() {
        return getResponse().getID();
    }

    /**
     * Returns the server chosen lease time-to-live in seconds.
     *
     * @return the ttl.
     */
    public long getTTL() {
        return getResponse().getTTL();
    }
}
