package alluxio.shaded.client.org.checkerframework.checker.alluxio.shaded.client.com.ilermsgs.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import alluxio.shaded.client.org.checkerframework.framework.qual.SubtypeOf;

/**
 * A string that is definitely a alluxio.shaded.client.com.iler message key.
 *
 * @checker_framework.manual #alluxio.shaded.client.com.ilermsgs-checker Compiler Message Key Checker
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@SubtypeOf(UnknownCompilerMessageKey.class)
public @interface CompilerMessageKey {}
