/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.ClientContext;
import alluxio.annotation.SuppressFBWarnings;
import alluxio.client.block.BlockMasterClient;
import alluxio.client.block.BlockMasterClientPool;
import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.block.stream.BlockWorkerClient;
import alluxio.client.block.stream.BlockWorkerClientPool;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContextReinitializer;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.client.file.FileSystemMasterClientPool;
import alluxio.client.file.options.UfsFileSystemOptions;
import alluxio.client.file.ufs.UfsBaseFileSystem;
import alluxio.client.metrics.MetricsHeartbeatContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.conf.ReconfigurableRegistry;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.UnavailableException;
import alluxio.grpc.GrpcServerAddress;
import alluxio.master.MasterClientContext;
import alluxio.master.MasterInquireClient;
import alluxio.membership.MasterMembershipManager;
import alluxio.membership.MembershipManager;
import alluxio.metrics.MetricsSystem;
import alluxio.network.netty.NettyChannelPool;
import alluxio.network.netty.NettyClient;
import alluxio.refresh.RefreshPolicy;
import alluxio.refresh.TimeoutRefresh;
import alluxio.resource.CloseableResource;
import alluxio.resource.DynamicResourcePool;
import alluxio.security.authentication.AuthenticationUtils;
import alluxio.security.user.UserState;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.io.netty.bootstrap.Bootstrap;
import alluxio.shaded.client.io.netty.channel.Channel;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.GuardedBy;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.CommonUtils;
import alluxio.util.IdUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.WorkerInfo;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.block.BlockWorker;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Only applied to sFileSystemContextFactory, sFileSystemContextFactory is for extension")
public class FileSystemContext
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemContext.class);
    public static FileSystemContextFactory sFileSystemContextFactory = new FileSystemContextFactory();
    private final String mId;
    private final BlockWorker mBlockWorker;
    private final AtomicBoolean mClosed = new AtomicBoolean(false);
    private final ConcurrentHashMap<SocketAddress, NettyChannelPool> mNettyChannelPools = new ConcurrentHashMap();
    @GuardedBy(value="this")
    private boolean mMetricsEnabled;
    private volatile MasterClientContext mMasterClientContext;
    private volatile FileSystemMasterClientPool mFileSystemMasterClientPool;
    private volatile BlockMasterClientPool mBlockMasterClientPool;
    private volatile ConcurrentHashMap<ClientPoolKey, BlockWorkerClientPool> mBlockWorkerClientPoolMap;
    @Nullable
    private MembershipManager mMembershipManager;
    @GuardedBy(value="this")
    private boolean mLocalWorkerInitialized;
    @GuardedBy(value="this")
    private WorkerNetAddress mLocalWorker;
    private volatile FileSystemContextReinitializer mReinitializer;
    private boolean mUriValidationEnabled = true;
    @GuardedBy(value="mWorkerInfoList")
    private final AtomicReference<List<BlockWorkerInfo>> mWorkerInfoList = new AtomicReference();
    @GuardedBy(value="mWorkerInfoList")
    private final RefreshPolicy mWorkerRefreshPolicy;
    private final List<InetSocketAddress> mMasterAddresses;

    public static FileSystemContext create(AlluxioConfiguration conf, List<InetSocketAddress> masterAddresses) {
        return FileSystemContext.create(ClientContext.create(conf), null, masterAddresses);
    }

    public static FileSystemContext create() {
        return FileSystemContext.create(ClientContext.create());
    }

    public static FileSystemContext create(AlluxioConfiguration conf) {
        Preconditions.checkNotNull(conf);
        return FileSystemContext.create(ClientContext.create(conf));
    }

    public static FileSystemContext create(Subject subject, AlluxioConfiguration conf) {
        return FileSystemContext.create(ClientContext.create(subject, conf));
    }

    public static FileSystemContext create(ClientContext clientContext) {
        return FileSystemContext.create(clientContext, null, null);
    }

    public static FileSystemContext create(ClientContext ctx, @Nullable BlockWorker blockWorker) {
        return FileSystemContext.create(ctx, blockWorker, null);
    }

    public static FileSystemContext create(ClientContext ctx, @Nullable BlockWorker blockWorker, @Nullable List<InetSocketAddress> masterAddresses) {
        FileSystemContext context = new FileSystemContext(ctx.getClusterConf(), blockWorker, masterAddresses);
        MasterInquireClient inquireClient = masterAddresses != null ? MasterInquireClient.Factory.createForAddresses(masterAddresses, ctx.getClusterConf(), ctx.getUserState()) : MasterInquireClient.Factory.create(ctx.getClusterConf(), ctx.getUserState());
        context.init(ctx, inquireClient);
        return context;
    }

    @VisibleForTesting
    public static FileSystemContext create(Subject subject, MasterInquireClient masterInquireClient, AlluxioConfiguration alluxioConf) {
        FileSystemContext context = new FileSystemContext(alluxioConf, null, null);
        ClientContext ctx = ClientContext.create(subject, alluxioConf);
        context.init(ctx, masterInquireClient);
        return context;
    }

    protected FileSystemContext(AlluxioConfiguration conf, @Nullable BlockWorker blockWorker, @Nullable List<InetSocketAddress> masterAddresses) {
        this.mId = IdUtils.createOrGetAppIdFromConfig(conf);
        this.mBlockWorker = blockWorker;
        this.mMasterAddresses = masterAddresses;
        this.mWorkerRefreshPolicy = new TimeoutRefresh(conf.getMs(PropertyKey.USER_WORKER_LIST_REFRESH_INTERVAL));
        LOG.debug("Created context with id: {}, with local block worker: {}", (Object)this.mId, (Object)(this.mBlockWorker != null ? 1 : 0));
    }

    protected synchronized void init(ClientContext clientContext, MasterInquireClient masterInquireClient) {
        this.initContext(clientContext, masterInquireClient);
        this.reCreateReinitialize(null);
    }

    protected void reCreateReinitialize(@Nullable FileSystemContextReinitializer fileSystemContextReinitializer) {
        this.mReinitializer = fileSystemContextReinitializer == null ? new FileSystemContextReinitializer(this) : fileSystemContextReinitializer;
    }

    protected synchronized void initContext(ClientContext ctx, MasterInquireClient masterInquireClient) {
        this.mClosed.set(false);
        this.mMasterClientContext = MasterClientContext.newBuilder(ctx).setMasterInquireClient(masterInquireClient).build();
        this.mMetricsEnabled = this.getClusterConf().getBoolean(PropertyKey.USER_METRICS_COLLECTION_ENABLED);
        if (this.mMetricsEnabled) {
            MetricsSystem.startSinks(this.getClusterConf().getString(PropertyKey.METRICS_CONF_FILE));
            MetricsHeartbeatContext.addHeartbeat(this.getClientContext(), masterInquireClient);
        }
        this.mFileSystemMasterClientPool = new FileSystemMasterClientPool(this.mMasterClientContext);
        this.mBlockMasterClientPool = new BlockMasterClientPool(this.mMasterClientContext);
        this.mBlockWorkerClientPoolMap = new ConcurrentHashMap();
        this.mUriValidationEnabled = ctx.getUriValidationEnabled();
        this.mMembershipManager = MembershipManager.Factory.create(this.getClusterConf());
    }

    @Override
    public synchronized void close() throws IOException {
        LOG.debug("Closing context with id: {}", (Object)this.mId);
        this.mReinitializer.close();
        this.closeContext();
        LOG.debug("Closed context with id: {}", (Object)this.mId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void closeContext() throws IOException {
        if (!this.mClosed.get()) {
            this.mClosed.set(true);
            LOG.debug("Closing fs master client pool with current size: {} for id: {}", (Object)this.mFileSystemMasterClientPool.size(), (Object)this.mId);
            this.mFileSystemMasterClientPool.close();
            this.mFileSystemMasterClientPool = null;
            LOG.debug("Closing block master client pool with size: {} for id: {}", (Object)this.mBlockMasterClientPool.size(), (Object)this.mId);
            this.mBlockMasterClientPool.close();
            this.mBlockMasterClientPool = null;
            for (BlockWorkerClientPool pool : this.mBlockWorkerClientPoolMap.values()) {
                LOG.debug("Closing block worker client pool with size: {} for id: {}", (Object)pool.size(), (Object)this.mId);
                pool.close();
            }
            this.mBlockWorkerClientPoolMap.clear();
            this.mBlockWorkerClientPoolMap = null;
            this.mLocalWorkerInitialized = false;
            this.mLocalWorker = null;
            if (this.mMetricsEnabled) {
                MetricsHeartbeatContext.removeHeartbeat(this.getClientContext());
            }
            LOG.debug("Closing membership manager.");
            try {
                MembershipManager ignoredCloser = this.mMembershipManager;
                Throwable throwable = null;
                if (ignoredCloser == null) return;
                if (throwable != null) {
                    try {
                        ignoredCloser.close();
                        return;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    return;
                }
                ignoredCloser.close();
                return;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        } else {
            LOG.warn("Attempted to close FileSystemContext which has already been closed or not initialized.");
        }
    }

    public FileSystemContextReinitializer.ReinitBlockerResource blockReinit() {
        try {
            return this.mReinitializer.block();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void reinit(boolean updateClusterConf) throws UnavailableException, IOException {
        InetSocketAddress masterAddr;
        try {
            masterAddr = this.getMasterAddress();
        }
        catch (IOException e) {
            throw new UnavailableException("Failed to get master address during reinitialization", e);
        }
        try (FileSystemContextReinitializer.ReinitAllowerResource r = this.mReinitializer.allow();){
            try {
                this.getClientContext().loadConf(masterAddr);
            }
            catch (AlluxioStatusException e) {
                throw new UnavailableException(String.format("Failed to load configuration from meta master (%s) during reinitialization", masterAddr), e);
            }
            LOG.debug("Reinitializing FileSystemContext: update cluster conf: {}", (Object)updateClusterConf);
            this.closeContext();
            ReconfigurableRegistry.update();
            this.initContext(this.getClientContext(), this.mMasterAddresses != null ? MasterInquireClient.Factory.createForAddresses(this.mMasterAddresses, this.getClusterConf(), this.getClientContext().getUserState()) : MasterInquireClient.Factory.create(this.getClusterConf(), this.getClientContext().getUserState()));
            LOG.debug("FileSystemContext re-initialized");
            this.mReinitializer.onSuccess();
        }
    }

    public String getId() {
        return this.mId;
    }

    public MasterClientContext getMasterClientContext() {
        return this.mMasterClientContext;
    }

    public ClientContext getClientContext() {
        return this.mMasterClientContext;
    }

    public AlluxioConfiguration getClusterConf() {
        return this.getClientContext().getClusterConf();
    }

    public synchronized InetSocketAddress getMasterAddress() throws UnavailableException {
        return this.mMasterClientContext.getMasterInquireClient().getPrimaryRpcAddress();
    }

    public synchronized boolean getUriValidationEnabled() {
        return this.mUriValidationEnabled;
    }

    public CloseableResource<FileSystemMasterClient> acquireMasterClientResource() {
        try (FileSystemContextReinitializer.ReinitBlockerResource r = this.blockReinit();){
            CloseableResource<FileSystemMasterClient> closeableResource = this.acquireClosableClientResource(this.mFileSystemMasterClientPool);
            return closeableResource;
        }
    }

    public CloseableResource<BlockMasterClient> acquireBlockMasterClientResource() {
        try (FileSystemContextReinitializer.ReinitBlockerResource r = this.blockReinit();){
            CloseableResource<BlockMasterClient> closeableResource = this.acquireClosableClientResource(this.mBlockMasterClientPool);
            return closeableResource;
        }
    }

    public Channel acquireNettyChannel(WorkerNetAddress workerNetAddress) throws IOException {
        SocketAddress address = NetworkAddressUtils.getDataPortSocketAddress(workerNetAddress, Configuration.global());
        if (!this.mNettyChannelPools.containsKey(address)) {
            Bootstrap bs = NettyClient.createClientBootstrap(address);
            bs.remoteAddress(address);
            NettyChannelPool pool = new NettyChannelPool(bs, Configuration.getInt(PropertyKey.USER_NETWORK_NETTY_CHANNEL_POOL_SIZE_MAX), Configuration.getMs(PropertyKey.USER_NETWORK_NETTY_CHANNEL_POOL_GC_THRESHOLD_MS));
            if (this.mNettyChannelPools.putIfAbsent(address, pool) != null) {
                pool.close();
            }
        }
        return (Channel)this.mNettyChannelPools.get(address).acquire();
    }

    protected ConcurrentHashMap<SocketAddress, NettyChannelPool> getNettyChannelPools() {
        return this.mNettyChannelPools;
    }

    public void releaseNettyChannel(WorkerNetAddress workerNetAddress, Channel channel) {
        SocketAddress address = NetworkAddressUtils.getDataPortSocketAddress(workerNetAddress, Configuration.global());
        if (this.mNettyChannelPools.containsKey(address)) {
            this.mNettyChannelPools.get(address).release(channel);
        } else {
            LOG.warn("No channel pool for address {}, closing channel instead. Context is closed: {}", (Object)address, (Object)this.mClosed.get());
            CommonUtils.closeChannel(channel);
        }
    }

    private <T> CloseableResource<T> acquireClosableClientResource(final DynamicResourcePool<T> pool) {
        try {
            return new CloseableResource<T>(pool.acquire()){

                @Override
                public void closeResource() {
                    pool.release(this.get());
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CloseableResource<BlockWorkerClient> acquireBlockWorkerClient(WorkerNetAddress workerNetAddress) throws IOException {
        try (FileSystemContextReinitializer.ReinitBlockerResource r = this.blockReinit();){
            CloseableResource<BlockWorkerClient> closeableResource = this.acquireBlockWorkerClientInternal(workerNetAddress, this.getClientContext(), this.getClientContext().getUserState());
            return closeableResource;
        }
    }

    private CloseableResource<BlockWorkerClient> acquireBlockWorkerClientInternal(WorkerNetAddress workerNetAddress, ClientContext context, UserState userState) throws IOException {
        SocketAddress address = NetworkAddressUtils.getRpcPortSocketAddress(workerNetAddress, context.getClusterConf());
        GrpcServerAddress serverAddress = GrpcServerAddress.create(workerNetAddress.getHost(), address);
        final ClientPoolKey key = new ClientPoolKey(address, AuthenticationUtils.getImpersonationUser(userState.getSubject(), context.getClusterConf()));
        final ConcurrentHashMap<ClientPoolKey, BlockWorkerClientPool> poolMap = this.mBlockWorkerClientPoolMap;
        BlockWorkerClientPool pool = poolMap.computeIfAbsent(key, k -> new BlockWorkerClientPool(userState, serverAddress, context.getClusterConf().getInt(PropertyKey.USER_BLOCK_WORKER_CLIENT_POOL_MIN), context.getClusterConf().getInt(PropertyKey.USER_BLOCK_WORKER_CLIENT_POOL_MAX), context.getClusterConf()));
        return new CloseableResource<BlockWorkerClient>((BlockWorkerClient)pool.acquire()){

            @Override
            public void closeResource() {
                FileSystemContext.releaseBlockWorkerClient((BlockWorkerClient)this.get(), key, poolMap);
            }
        };
    }

    private static void releaseBlockWorkerClient(BlockWorkerClient client, ClientPoolKey key, ConcurrentHashMap<ClientPoolKey, BlockWorkerClientPool> poolMap) {
        if (client == null) {
            return;
        }
        if (poolMap.containsKey(key)) {
            poolMap.get(key).release(client);
        } else {
            LOG.warn("No client pool for key {}, closing client instead. Context may have been closed", (Object)key);
            try {
                client.close();
            }
            catch (IOException e) {
                LOG.warn("Error closing block worker client for key {}", (Object)key, (Object)e);
            }
        }
    }

    public synchronized boolean hasProcessLocalWorker() {
        return this.mBlockWorker != null;
    }

    public Optional<BlockWorker> getProcessLocalWorker() {
        return Optional.ofNullable(this.mBlockWorker);
    }

    public synchronized boolean hasNodeLocalWorker() throws IOException {
        if (!this.mLocalWorkerInitialized) {
            this.initializeLocalWorker();
        }
        return this.mLocalWorker != null;
    }

    public synchronized WorkerNetAddress getNodeLocalWorker() throws IOException {
        if (!this.mLocalWorkerInitialized) {
            this.initializeLocalWorker();
        }
        return this.mLocalWorker;
    }

    public List<BlockWorkerInfo> getCachedWorkers() throws IOException {
        return this.getCachedWorkers(GetWorkerListType.LIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BlockWorkerInfo> getCachedWorkers(GetWorkerListType type) throws IOException {
        AtomicReference<List<BlockWorkerInfo>> atomicReference = this.mWorkerInfoList;
        synchronized (atomicReference) {
            if (this.mWorkerInfoList.get() == null || this.mWorkerInfoList.get().isEmpty() || this.mWorkerRefreshPolicy.attempt()) {
                switch (type) {
                    case ALL: {
                        this.mWorkerInfoList.set(this.getAllWorkers());
                        break;
                    }
                    case LIVE: {
                        this.mWorkerInfoList.set(this.getLiveWorkers());
                        break;
                    }
                    case LOST: {
                        this.mWorkerInfoList.set(this.getLostWorkers());
                        break;
                    }
                }
            }
            return this.mWorkerInfoList.get();
        }
    }

    public List<BlockWorkerInfo> getLiveWorkers() throws IOException {
        try (FileSystemContextReinitializer.ReinitBlockerResource r = this.blockReinit();){
            if (this.mMembershipManager != null && !(this.mMembershipManager instanceof MasterMembershipManager)) {
                List<BlockWorkerInfo> list = this.mMembershipManager.getLiveMembers().stream().map(w -> new BlockWorkerInfo(w.getIdentity(), w.getAddress(), w.getCapacityBytes(), w.getUsedBytes(), true)).collect(Collectors.toList());
                return list;
            }
        }
        var2_2 = null;
        try (CloseableResource<BlockMasterClient> masterClientResource = this.acquireBlockMasterClientResource();){
            List<BlockWorkerInfo> list = masterClientResource.get().getWorkerInfoList().stream().map(w -> new BlockWorkerInfo(w.getIdentity(), w.getAddress(), w.getCapacityBytes(), w.getUsedBytes(), true)).collect(Collectors.toList());
            return list;
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    public List<BlockWorkerInfo> getLostWorkers() throws IOException {
        try (FileSystemContextReinitializer.ReinitBlockerResource r = this.blockReinit();){
            if (this.mMembershipManager != null && !(this.mMembershipManager instanceof MasterMembershipManager)) {
                List<BlockWorkerInfo> list = this.mMembershipManager.getFailedMembers().stream().map(w -> new BlockWorkerInfo(w.getIdentity(), w.getAddress(), w.getCapacityBytes(), w.getUsedBytes(), false)).collect(Collectors.toList());
                return list;
            }
        }
        var2_2 = null;
        try (CloseableResource<BlockMasterClient> masterClientResource = this.acquireBlockMasterClientResource();){
            List<BlockWorkerInfo> list = masterClientResource.get().getLostWorkerInfoList().stream().map(w -> new BlockWorkerInfo(w.getIdentity(), w.getAddress(), w.getCapacityBytes(), w.getUsedBytes(), false)).collect(Collectors.toList());
            return list;
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    public List<BlockWorkerInfo> getAllWorkers() throws IOException {
        try (FileSystemContextReinitializer.ReinitBlockerResource r = this.blockReinit();){
            if (this.mMembershipManager != null && !(this.mMembershipManager instanceof MasterMembershipManager)) {
                List<BlockWorkerInfo> liveWorkers = this.mMembershipManager.getLiveMembers().stream().map(w -> new BlockWorkerInfo(w.getIdentity(), w.getAddress(), w.getCapacityBytes(), w.getUsedBytes(), true)).collect(Collectors.toList());
                List<BlockWorkerInfo> lostWorkers = this.mMembershipManager.getFailedMembers().stream().map(w -> new BlockWorkerInfo(w.getIdentity(), w.getAddress(), w.getCapacityBytes(), w.getUsedBytes(), false)).collect(Collectors.toList());
                List<BlockWorkerInfo> list = this.combineAllWorkers(liveWorkers, lostWorkers);
                return list;
            }
        }
        var2_2 = null;
        try (CloseableResource<BlockMasterClient> masterClientResource = this.acquireBlockMasterClientResource();){
            List<BlockWorkerInfo> liveWorkers = masterClientResource.get().getWorkerInfoList().stream().map(w -> new BlockWorkerInfo(w.getIdentity(), w.getAddress(), w.getCapacityBytes(), w.getUsedBytes(), true)).collect(Collectors.toList());
            List<BlockWorkerInfo> lostWorkers = masterClientResource.get().getLostWorkerInfoList().stream().map(w -> new BlockWorkerInfo(w.getIdentity(), w.getAddress(), w.getCapacityBytes(), w.getUsedBytes(), false)).collect(Collectors.toList());
            List<BlockWorkerInfo> list = this.combineAllWorkers(liveWorkers, lostWorkers);
            return list;
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    private List<BlockWorkerInfo> combineAllWorkers(List<BlockWorkerInfo> liveWorkers, List<BlockWorkerInfo> lostWorkers) {
        HashMap allWorkersMap = new HashMap();
        liveWorkers.forEach(liveWorker -> allWorkersMap.put(liveWorker.getNetAddress(), liveWorker));
        lostWorkers.forEach(lostWorker -> allWorkersMap.put(lostWorker.getNetAddress(), lostWorker));
        return new ArrayList<BlockWorkerInfo>(allWorkersMap.values());
    }

    protected ConcurrentHashMap<ClientPoolKey, BlockWorkerClientPool> getBlockWorkerClientPoolMap() {
        return this.mBlockWorkerClientPoolMap;
    }

    private void initializeLocalWorker() throws IOException {
        List<WorkerNetAddress> addresses = this.getWorkerAddresses();
        if (!addresses.isEmpty() && addresses.get(0).getHost().equals(NetworkAddressUtils.getClientHostName(this.getClusterConf()))) {
            this.mLocalWorker = addresses.get(0);
        }
        this.mLocalWorkerInitialized = true;
    }

    public FileSystem createUfsBaseFileSystem(Optional<UfsFileSystemOptions> ufsOptions) {
        Preconditions.checkArgument(ufsOptions.isPresent(), "Missing UfsFileSystemOptions in FileSystemOptions");
        return new UfsBaseFileSystem(this, ufsOptions.get());
    }

    private List<WorkerNetAddress> getWorkerAddresses() throws IOException {
        List<WorkerInfo> infos;
        try (CloseableResource<BlockMasterClient> masterClientResource = this.acquireBlockMasterClientResource();){
            infos = masterClientResource.get().getWorkerInfoList();
        }
        if (infos.isEmpty()) {
            throw new UnavailableException(ExceptionMessage.NO_WORKER_AVAILABLE.getMessage(new Object[0]));
        }
        ArrayList<WorkerNetAddress> workerNetAddresses = new ArrayList<WorkerNetAddress>();
        ArrayList<WorkerNetAddress> localWorkerNetAddresses = new ArrayList<WorkerNetAddress>();
        String localHostname = NetworkAddressUtils.getClientHostName(this.getClusterConf());
        for (WorkerInfo info : infos) {
            WorkerNetAddress netAddress = info.getAddress();
            if (netAddress.getHost().equals(localHostname)) {
                localWorkerNetAddresses.add(netAddress);
            }
            workerNetAddresses.add(netAddress);
        }
        return localWorkerNetAddresses.isEmpty() ? workerNetAddresses : localWorkerNetAddresses;
    }

    protected static class ClientPoolKey {
        private final SocketAddress mSocketAddress;
        private final String mUsername;

        public ClientPoolKey(SocketAddress socketAddress, String username) {
            this.mSocketAddress = socketAddress;
            this.mUsername = username;
        }

        public int hashCode() {
            return Objects.hashCode(this.mSocketAddress, this.mUsername);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClientPoolKey)) {
                return false;
            }
            ClientPoolKey that = (ClientPoolKey)o;
            return Objects.equal(this.mSocketAddress, that.mSocketAddress) && Objects.equal(this.mUsername, that.mUsername);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("socketAddress", this.mSocketAddress).add("username", this.mUsername).toString();
        }
    }

    public static class FileSystemContextFactory {
        public FileSystemContext create(AlluxioConfiguration conf, List<InetSocketAddress> masterAddresses) {
            return FileSystemContext.create(conf, masterAddresses);
        }

        public FileSystemContext create() {
            return FileSystemContext.create();
        }

        public FileSystemContext create(AlluxioConfiguration conf) {
            return FileSystemContext.create(conf);
        }

        public FileSystemContext create(Subject subject, AlluxioConfiguration conf) {
            return FileSystemContext.create(subject, conf);
        }

        public FileSystemContext create(ClientContext clientContext) {
            return FileSystemContext.create(clientContext);
        }

        public FileSystemContext create(ClientContext ctx, @Nullable BlockWorker blockWorker) {
            return FileSystemContext.create(ctx, blockWorker);
        }

        public FileSystemContext create(ClientContext ctx, @Nullable BlockWorker blockWorker, @Nullable List<InetSocketAddress> masterAddresses) {
            return FileSystemContext.create(ctx, blockWorker, masterAddresses);
        }

        public FileSystemContext create(Subject subject, MasterInquireClient masterInquireClient, AlluxioConfiguration alluxioConf) {
            return FileSystemContext.create(subject, masterInquireClient, alluxioConf);
        }
    }

    public static enum GetWorkerListType {
        ALL,
        LIVE,
        LOST;

    }
}

