/*
 * Decompiled with CFR 0.152.
 */
package alluxio.conf;

import alluxio.shaded.client.com.google.common.base.Objects;

public class Source
implements Comparable<Source> {
    public static final Source UNKNOWN = new Source(Type.UNKNOWN);
    public static final Source DEFAULT = new Source(Type.DEFAULT);
    public static final Source CLUSTER_DEFAULT = new Source(Type.CLUSTER_DEFAULT);
    public static final Source SYSTEM_PROPERTY = new Source(Type.SYSTEM_PROPERTY);
    public static final Source PATH_DEFAULT = new Source(Type.PATH_DEFAULT);
    public static final Source RUNTIME = new Source(Type.RUNTIME);
    public static final Source MOUNT_OPTION = new Source(Type.MOUNT_OPTION);
    public static final Source REFERENCE = new Source(Type.REFERENCE);
    protected final Type mType;

    private Source(Type type) {
        this.mType = type;
    }

    public Type getType() {
        return this.mType;
    }

    public static Source siteProperty(String filename) {
        return new SitePropertySource(filename);
    }

    @Override
    public int compareTo(Source other) {
        return this.mType.compareTo(other.mType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Source)) {
            return false;
        }
        Source other = (Source)o;
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.mType});
    }

    public String toString() {
        return this.mType.name();
    }

    private static final class SitePropertySource
    extends Source {
        private final String mFilename;

        private SitePropertySource(String filename) {
            super(Type.SITE_PROPERTY);
            this.mFilename = filename;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SitePropertySource that = (SitePropertySource)o;
            return Objects.equal(this.mFilename, that.mFilename);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.mFilename);
        }

        @Override
        public String toString() {
            return String.format("%s (%s)", new Object[]{this.mType, this.mFilename});
        }
    }

    public static enum Type {
        UNKNOWN,
        DEFAULT,
        CLUSTER_DEFAULT,
        REFERENCE,
        SITE_PROPERTY,
        SYSTEM_PROPERTY,
        PATH_DEFAULT,
        RUNTIME,
        MOUNT_OPTION;

    }
}

