/*
 * Decompiled with CFR 0.152.
 */
package alluxio.file;

import java.util.Objects;

public abstract class FileId {
    private FileId() {
    }

    public static FileId of(long fileId) {
        return new LongId(fileId);
    }

    public static FileId of(String fileId) {
        return new StringId(fileId);
    }

    static final class LongId
    extends FileId {
        private final long mFileId;

        public LongId(long fileId) {
            this.mFileId = fileId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LongId longId = (LongId)o;
            return this.mFileId == longId.mFileId;
        }

        public int hashCode() {
            return Long.hashCode(this.mFileId);
        }

        public String toString() {
            return String.valueOf(this.mFileId);
        }
    }

    static final class StringId
    extends FileId {
        private final String mFileId;

        public StringId(String fileId) {
            this.mFileId = Objects.requireNonNull(fileId, "fileId");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StringId stringId = (StringId)o;
            return Objects.equals(this.mFileId, stringId.mFileId);
        }

        public int hashCode() {
            return this.mFileId.hashCode();
        }

        public String toString() {
            return this.mFileId;
        }
    }
}

