/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.CancelledException;
import alluxio.exception.status.DeadlineExceededException;
import alluxio.exception.status.NotFoundException;
import alluxio.exception.status.UnavailableException;
import alluxio.grpc.GetServiceVersionPRequest;
import alluxio.grpc.GrpcChannel;
import alluxio.grpc.GrpcChannelBuilder;
import alluxio.grpc.GrpcServerAddress;
import alluxio.grpc.ServiceType;
import alluxio.grpc.ServiceVersionClientServiceGrpc;
import alluxio.master.MasterInquireClient;
import alluxio.retry.RetryPolicy;
import alluxio.retry.RetryUtils;
import alluxio.security.user.UserState;
import alluxio.shaded.client.com.google.common.collect.Lists;
import alluxio.shaded.client.com.google.common.util.concurrent.ThreadFactoryBuilder;
import alluxio.shaded.client.io.grpc.StatusRuntimeException;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.uri.Authority;
import alluxio.uri.MultiMasterAuthority;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingMasterInquireClient
implements MasterInquireClient {
    private static final Logger LOG = LoggerFactory.getLogger(PollingMasterInquireClient.class);
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("pollingMasterThread-%d").build());
    private final MultiMasterConnectDetails mConnectDetails;
    private final Supplier<RetryPolicy> mRetryPolicySupplier;
    private final AlluxioConfiguration mConfiguration;
    private final UserState mUserState;
    private final ServiceType mServiceType;

    public PollingMasterInquireClient(List<InetSocketAddress> masterAddresses, AlluxioConfiguration alluxioConf, UserState userState, ServiceType serviceType) {
        this(masterAddresses, RetryUtils::defaultClientRetry, alluxioConf, userState, serviceType);
    }

    public PollingMasterInquireClient(List<InetSocketAddress> masterAddresses, Supplier<RetryPolicy> retryPolicySupplier, AlluxioConfiguration alluxioConf, ServiceType serviceType) {
        this(masterAddresses, retryPolicySupplier, alluxioConf, UserState.Factory.create(alluxioConf), serviceType);
    }

    public PollingMasterInquireClient(List<InetSocketAddress> masterAddresses, Supplier<RetryPolicy> retryPolicySupplier, AlluxioConfiguration alluxioConf, UserState userState, ServiceType serviceType) {
        this.mConnectDetails = new MultiMasterConnectDetails(masterAddresses);
        this.mRetryPolicySupplier = retryPolicySupplier;
        this.mConfiguration = alluxioConf;
        this.mUserState = userState;
        this.mServiceType = serviceType;
    }

    @Override
    public InetSocketAddress getPrimaryRpcAddress() throws UnavailableException {
        RetryPolicy retry = this.mRetryPolicySupplier.get();
        while (retry.attempt()) {
            InetSocketAddress address = this.getAddress();
            if (address == null) continue;
            return address;
        }
        throw new UnavailableException(String.format("Failed to determine primary master rpc address after polling each of %s %d times", this.mConnectDetails.getAddresses(), retry.getAttemptCount()));
    }

    @Nullable
    private InetSocketAddress getAddress() {
        List<InetSocketAddress> addresses;
        if (this.mConfiguration.getBoolean(PropertyKey.USER_RPC_SHUFFLE_MASTERS_ENABLED)) {
            addresses = Lists.newArrayList(this.mConnectDetails.getAddresses());
            Collections.shuffle(addresses);
        } else {
            addresses = this.mConnectDetails.getAddresses();
        }
        if (this.mConfiguration.getBoolean(PropertyKey.USER_MASTER_POLLING_CONCURRENT)) {
            return this.findActiveAddressConcurrent(addresses);
        }
        return this.findActiveAddress(addresses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private InetSocketAddress findActiveAddressConcurrent(List<InetSocketAddress> addresses) {
        ArrayList<Future<InetSocketAddress>> futures = new ArrayList<Future<InetSocketAddress>>(addresses.size());
        try {
            ExecutorCompletionService<InetSocketAddress> completionService = new ExecutorCompletionService<InetSocketAddress>(EXECUTOR_SERVICE);
            for (InetSocketAddress address : addresses) {
                futures.add(completionService.submit(() -> this.checkActiveAddress(address)));
            }
            for (int i = 0; i < addresses.size(); ++i) {
                try {
                    Future future = completionService.take();
                    InetSocketAddress address = (InetSocketAddress)future.get();
                    if (address == null) continue;
                    InetSocketAddress inetSocketAddress = address;
                    return inetSocketAddress;
                }
                catch (InterruptedException | ExecutionException e) {
                    break;
                }
            }
            InetSocketAddress inetSocketAddress = null;
            return inetSocketAddress;
        }
        finally {
            futures.forEach(it -> it.cancel(true));
        }
    }

    @Nullable
    private InetSocketAddress findActiveAddress(List<InetSocketAddress> addresses) {
        for (InetSocketAddress address : addresses) {
            try {
                if (this.checkActiveAddress(address) == null) continue;
                return address;
            }
            catch (AlluxioStatusException e) {
                break;
            }
        }
        return null;
    }

    private InetSocketAddress checkActiveAddress(InetSocketAddress address) throws AlluxioStatusException {
        try {
            LOG.debug("Checking whether {} is listening for RPCs", (Object)address);
            this.pingMetaService(address);
            LOG.debug("Successfully connected to {}", (Object)address);
            return address;
        }
        catch (UnavailableException e) {
            LOG.debug("Failed to connect to {}", (Object)address);
            return null;
        }
        catch (DeadlineExceededException e) {
            LOG.debug("Timeout while connecting to {}", (Object)address);
            return null;
        }
        catch (CancelledException e) {
            LOG.debug("Cancelled while connecting to {}", (Object)address);
            return null;
        }
        catch (NotFoundException e) {
            LOG.debug("Meta service rpc endpoint not found on {}. {}", (Object)address, (Object)e);
            return null;
        }
        catch (AlluxioStatusException e) {
            LOG.error("Error while connecting to {}. {}", (Object)address, (Object)e);
            throw e;
        }
    }

    private void pingMetaService(InetSocketAddress address) throws AlluxioStatusException {
        GrpcChannel channel = GrpcChannelBuilder.newBuilder(GrpcServerAddress.create(address), this.mConfiguration).setSubject(this.mUserState.getSubject()).disableAuthentication().build();
        ServiceVersionClientServiceGrpc.ServiceVersionClientServiceBlockingStub versionClient = (ServiceVersionClientServiceGrpc.ServiceVersionClientServiceBlockingStub)ServiceVersionClientServiceGrpc.newBlockingStub(channel).withDeadlineAfter(this.mConfiguration.getMs(PropertyKey.USER_MASTER_POLLING_TIMEOUT), TimeUnit.MILLISECONDS);
        try {
            versionClient.getServiceVersion(GetServiceVersionPRequest.newBuilder().setServiceType(this.mServiceType).build());
        }
        catch (StatusRuntimeException e) {
            throw AlluxioStatusException.fromThrowable(e);
        }
        finally {
            channel.shutdown();
        }
    }

    @Override
    public List<InetSocketAddress> getMasterRpcAddresses() {
        return this.mConnectDetails.getAddresses();
    }

    @Override
    public MasterInquireClient.ConnectDetails getConnectDetails() {
        return this.mConnectDetails;
    }

    public static class MultiMasterConnectDetails
    implements MasterInquireClient.ConnectDetails {
        private final List<InetSocketAddress> mAddresses;

        public MultiMasterConnectDetails(List<InetSocketAddress> addresses) {
            this.mAddresses = addresses;
        }

        public List<InetSocketAddress> getAddresses() {
            return this.mAddresses;
        }

        @Override
        public Authority toAuthority() {
            return new MultiMasterAuthority(this.mAddresses.stream().map(addr -> addr.getHostString() + ":" + addr.getPort()).collect(Collectors.joining(",")));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MultiMasterConnectDetails)) {
                return false;
            }
            MultiMasterConnectDetails that = (MultiMasterConnectDetails)o;
            return this.mAddresses.equals(that.mAddresses);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.mAddresses);
        }

        public String toString() {
            return this.toAuthority().toString();
        }
    }
}

