/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.prometheus.metrics.exporter.servlet.jakarta;

import alluxio.shaded.client.io.prometheus.metrics.exporter.common.PrometheusHttpExchange;
import alluxio.shaded.client.io.prometheus.metrics.exporter.common.PrometheusHttpRequest;
import alluxio.shaded.client.io.prometheus.metrics.exporter.common.PrometheusHttpResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

public class HttpExchangeAdapter
implements PrometheusHttpExchange {
    private final Request request;
    private final Response response;

    public HttpExchangeAdapter(HttpServletRequest request, HttpServletResponse response) {
        this.request = new Request(request);
        this.response = new Response(response);
    }

    @Override
    public PrometheusHttpRequest getRequest() {
        return this.request;
    }

    @Override
    public PrometheusHttpResponse getResponse() {
        return this.response;
    }

    @Override
    public void handleException(IOException e) throws IOException {
        throw e;
    }

    @Override
    public void handleException(RuntimeException e) {
        throw e;
    }

    @Override
    public void close() {
    }

    public static class Request
    implements PrometheusHttpRequest {
        private final HttpServletRequest request;

        public Request(HttpServletRequest request) {
            this.request = request;
        }

        @Override
        public String getQueryString() {
            return this.request.getQueryString();
        }

        @Override
        public Enumeration<String> getHeaders(String name) {
            return this.request.getHeaders(name);
        }

        @Override
        public String getMethod() {
            return this.request.getMethod();
        }
    }

    public static class Response
    implements PrometheusHttpResponse {
        private final HttpServletResponse response;

        public Response(HttpServletResponse response) {
            this.response = response;
        }

        @Override
        public void setHeader(String name, String value) {
            this.response.setHeader(name, value);
        }

        @Override
        public OutputStream sendHeadersAndGetBody(int statusCode, int contentLength) throws IOException {
            if (this.response.getHeader("Content-Length") == null && contentLength > 0) {
                this.response.setContentLength(contentLength);
            }
            this.response.setStatus(statusCode);
            return this.response.getOutputStream();
        }
    }
}

