/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.net.jodah.failsafe;

import alluxio.shaded.client.net.jodah.failsafe.ExecutionContext;
import alluxio.shaded.client.net.jodah.failsafe.FailurePolicy;
import alluxio.shaded.client.net.jodah.failsafe.function.DelayFunction;
import alluxio.shaded.client.net.jodah.failsafe.internal.util.Assert;
import java.time.Duration;

public abstract class DelayablePolicy<S, R>
extends FailurePolicy<S, R> {
    DelayFunction<R, ? extends Throwable> delayFn;
    Object delayResult;
    Class<? extends Throwable> delayFailure;

    public DelayFunction<R, ? extends Throwable> getDelayFn() {
        return this.delayFn;
    }

    public S withDelay(DelayFunction<R, ? extends Throwable> delayFunction) {
        Assert.notNull(delayFunction, "delayFunction");
        this.delayFn = delayFunction;
        return (S)this;
    }

    public <F extends Throwable> S withDelayOn(DelayFunction<R, F> delayFunction, Class<F> failure) {
        this.withDelay(delayFunction);
        Assert.notNull(failure, "failure");
        this.delayFailure = failure;
        return (S)this;
    }

    public S withDelayWhen(DelayFunction<R, ? extends Throwable> delayFunction, R result) {
        this.withDelay(delayFunction);
        Assert.notNull(result, "result");
        this.delayResult = result;
        return (S)this;
    }

    protected Duration computeDelay(ExecutionContext context) {
        Duration computed = null;
        if (context != null && this.delayFn != null) {
            Object exResult = context.getLastResult();
            Object exFailure = context.getLastFailure();
            if ((this.delayResult == null || this.delayResult.equals(exResult)) && (this.delayFailure == null || exFailure != null && this.delayFailure.isAssignableFrom(exFailure.getClass()))) {
                computed = this.delayFn.computeDelay(exResult, (Throwable)exFailure, context);
            }
        }
        return computed != null && !computed.isNegative() ? computed : null;
    }
}

