/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.CacheUsageView;
import alluxio.client.quota.CacheScope;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public interface CacheUsage
extends CacheUsageView {
    default public CacheUsageView snapshot() {
        return new CacheUsageView.ImmutableCacheUsageView(this.used(), this.available(), this.capacity());
    }

    public Optional<CacheUsage> partitionedBy(PartitionDescriptor<?> var1);

    public static final class FilePartition
    implements PartitionDescriptor<String> {
        private final String mFileId;

        public FilePartition(String fileId) {
            this.mFileId = fileId;
        }

        @Override
        public String getIdentifier() {
            return this.mFileId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilePartition that = (FilePartition)o;
            return Objects.equals(this.mFileId, that.mFileId);
        }

        public int hashCode() {
            return Objects.hash(this.mFileId);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("fileId", this.mFileId).toString();
        }
    }

    public static final class ScopePartition
    implements PartitionDescriptor<CacheScope> {
        private final CacheScope mScope;

        public ScopePartition(CacheScope scope) {
            this.mScope = scope;
        }

        @Override
        public CacheScope getIdentifier() {
            return this.mScope;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScopePartition that = (ScopePartition)o;
            return Objects.equals(this.mScope, that.mScope);
        }

        public int hashCode() {
            return Objects.hash(this.mScope);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("scope", this.mScope).toString();
        }
    }

    public static final class DirPartition
    implements PartitionDescriptor<Integer> {
        private final int mIndex;

        public DirPartition(int index) {
            this.mIndex = index;
        }

        @Override
        public Integer getIdentifier() {
            return this.mIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DirPartition that = (DirPartition)o;
            return this.mIndex == that.mIndex;
        }

        public int hashCode() {
            return Objects.hash(this.mIndex);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("dirIndex", this.mIndex).toString();
        }
    }

    public static interface PartitionDescriptor<T> {
        public T getIdentifier();

        public static FilePartition file(String fileId) {
            return new FilePartition(fileId);
        }

        public static DirPartition dir(int index) {
            return new DirPartition(index);
        }

        public static ScopePartition scope(CacheScope scope) {
            return new ScopePartition(scope);
        }
    }
}

