/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.software.amazon.ionsystem;

import alluxio.shaded.client.software.amazon.ionIonCatalog;
import alluxio.shaded.client.software.amazon.ionSymbolTable;
import alluxio.shaded.client.software.amazon.ionsystem.IonWriterBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class IonWriterBuilderBase<T extends IonWriterBuilderBase>
extends IonWriterBuilder {
    private ionIonCatalog myCatalog;
    private ionSymbolTable[] myImports;

    protected IonWriterBuilderBase() {
    }

    protected IonWriterBuilderBase(IonWriterBuilderBase that) {
        this.myCatalog = that.myCatalog;
        this.myImports = that.myImports;
    }

    abstract T copy();

    abstract T immutable();

    abstract T mutable();

    protected void mutationCheck() {
        throw new UnsupportedOperationException("This builder is immutable");
    }

    public final ionIonCatalog getCatalog() {
        return this.myCatalog;
    }

    public void setCatalog(ionIonCatalog catalog) {
        this.mutationCheck();
        this.myCatalog = catalog;
    }

    public T withCatalog(ionIonCatalog catalog) {
        T b = this.mutable();
        ((IonWriterBuilderBase)b).setCatalog(catalog);
        return b;
    }

    private static ionSymbolTable[] safeCopy(ionSymbolTable[] imports) {
        if (imports != null && imports.length != 0) {
            imports = (ionSymbolTable[])imports.clone();
        }
        return imports;
    }

    public final ionSymbolTable[] getImports() {
        return IonWriterBuilderBase.safeCopy(this.myImports);
    }

    public void setImports(ionSymbolTable ... imports) {
        this.mutationCheck();
        this.myImports = IonWriterBuilderBase.safeCopy(imports);
    }

    public T withImports(ionSymbolTable ... imports) {
        T b = this.mutable();
        ((IonWriterBuilderBase)b).setImports(imports);
        return b;
    }
}

