package alluxio.shaded.client.com.rabbitmq.client.impl;

import alluxio.shaded.client.com.rabbitmq.client.Command;
import alluxio.shaded.client.com.rabbitmq.client.TrafficListener;
import alluxio.shaded.client.org.slf4j.Logger;
import alluxio.shaded.client.org.slf4j.LoggerFactory;

/**
 * {@link TrafficListener} that logs {@link Command} at <code>TRACE</code> level.
 * <p>
 * This implementation checks whether the <code>TRACE</code> log level
 * is enabled before logging anything. This {@link TrafficListener}
 * should only be activated for debugging purposes, not in a production
 * environment.
 *
 * @see TrafficListener
 * @see alluxio.shaded.client.com.rabbitmq.client.ConnectionFactory#setTrafficListener(TrafficListener)
 * @since 5.5.0
 */
public class LogTrafficListener implements TrafficListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(LogTrafficListener.class);

    @Override
    public void write(Command outboundCommand) {
        if (shouldLog(outboundCommand)) {
            LOGGER.trace("Outbound alluxio.shaded.client.com.and: {}", outboundCommand);
        }
    }

    @Override
    public void read(Command inboundCommand) {
        if (shouldLog(inboundCommand)) {
            LOGGER.trace("Inbound alluxio.shaded.client.com.and: {}", inboundCommand);
        }
    }

    protected boolean shouldLog(Command alluxio.shaded.client.com.and) {
        return LOGGER.isTraceEnabled();
    }
}
