package alluxio.shaded.client.io.etcd.jetcd.api;

import static alluxio.shaded.client.io.etcd.jetcd.api.MaintenanceGrpc.getServiceDescriptor;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncBidiStreamingCall;


@alluxio.shaded.client.javax.annotation.Generated(
value = "by VertxGrpc generator",
alluxio.shaded.client.com.ents = "Source: rpc.proto")
public final class VertxMaintenanceGrpc {
    private VertxMaintenanceGrpc() {}

    public static MaintenanceVertxStub newVertxStub(alluxio.shaded.client.io.grpc.Channel channel) {
        return new MaintenanceVertxStub(channel);
    }

    
    public static final class MaintenanceVertxStub extends alluxio.shaded.client.io.grpc.stub.AbstractStub<MaintenanceVertxStub> {
        private final alluxio.shaded.client.io.vertx.core.impl.ContextInternal ctx;
        private MaintenanceGrpc.MaintenanceStub delegateStub;

        private MaintenanceVertxStub(alluxio.shaded.client.io.grpc.Channel channel) {
            super(channel);
            delegateStub = MaintenanceGrpc.newStub(channel);
            this.ctx = (alluxio.shaded.client.io.vertx.core.impl.ContextInternal) alluxio.shaded.client.io.vertx.core.Vertx.currentContext();
        }

        private MaintenanceVertxStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
            delegateStub = MaintenanceGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (alluxio.shaded.client.io.vertx.core.impl.ContextInternal) alluxio.shaded.client.io.vertx.core.Vertx.currentContext();
        }

        @Override
        protected MaintenanceVertxStub build(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
            return new MaintenanceVertxStub(channel, callOptions);
        }

        /**
         * <pre>
         *  Range gets the keys in the range from the key-value store.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AlarmResponse> alarm(alluxio.shaded.client.io.etcd.jetcd.api.AlarmRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::alarm);
        }

        /**
         * <pre>
         *  Put puts the given key into the key-value store.
         *  A put request increments the revision of the key-value store
         *  and generates one event in the event history.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.StatusResponse> status(alluxio.shaded.client.io.etcd.jetcd.api.StatusRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::status);
        }

        /**
         * <pre>
         *  DeleteRange deletes the given range from the key-value store.
         *  A delete request increments the revision of the key-value store
         *  and generates a delete event in the event history for every deleted key.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.DefragmentResponse> defragment(alluxio.shaded.client.io.etcd.jetcd.api.DefragmentRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::defragment);
        }

        /**
         * <pre>
         *  Txn processes multiple requests in a single transaction.
         *  A txn request increments the revision of the key-value store
         *  and generates events with the same revision for every alluxio.shaded.client.com.leted request.
         *  It is not allowed to modify the same key several times within one txn.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.HashResponse> hash(alluxio.shaded.client.io.etcd.jetcd.api.HashRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::hash);
        }

        /**
         * <pre>
         *  Compact alluxio.shaded.client.com.acts the event history in the etcd key-value store. The key-value
         *  store should be periodically alluxio.shaded.client.com.acted or the event history will continue to grow
         *  indefinitely.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.HashKVResponse> hashKV(alluxio.shaded.client.io.etcd.jetcd.api.HashKVRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::hashKV);
        }

        /**
         * <pre>
         *  MoveLeader requests current leader node to transfer its leadership to transferee.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.MoveLeaderResponse> moveLeader(alluxio.shaded.client.io.etcd.jetcd.api.MoveLeaderRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::moveLeader);
        }

        /**
         * <pre>
         *  Snapshot sends a snapshot of the entire backend from a member over a stream to a client.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.streams.ReadStream<alluxio.shaded.client.io.etcd.jetcd.api.SnapshotResponse> snapshot(alluxio.shaded.client.io.etcd.jetcd.api.SnapshotRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToMany(ctx, request, delegateStub::snapshot);
        }

    }

    
    public static abstract class MaintenanceVertxImplBase implements alluxio.shaded.client.io.grpc.BindableService {
        private String alluxio.shaded.client.com.ression;

        /**
         * Set whether the server will try to use a alluxio.shaded.client.com.ressed response.
         *
         * @param alluxio.shaded.client.com.ression the alluxio.shaded.client.com.ression, e.g {@code gzip}
         */
        public MaintenanceVertxImplBase withCompression(String alluxio.shaded.client.com.ression) {
            this.alluxio.shaded.client.com.ression = alluxio.shaded.client.com.ression;
            return this;
        }

        /**
         * <pre>
         *  Range gets the keys in the range from the key-value store.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.AlarmResponse> alarm(alluxio.shaded.client.io.etcd.jetcd.api.AlarmRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Put puts the given key into the key-value store.
         *  A put request increments the revision of the key-value store
         *  and generates one event in the event history.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.StatusResponse> status(alluxio.shaded.client.io.etcd.jetcd.api.StatusRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  DeleteRange deletes the given range from the key-value store.
         *  A delete request increments the revision of the key-value store
         *  and generates a delete event in the event history for every deleted key.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.DefragmentResponse> defragment(alluxio.shaded.client.io.etcd.jetcd.api.DefragmentRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Txn processes multiple requests in a single transaction.
         *  A txn request increments the revision of the key-value store
         *  and generates events with the same revision for every alluxio.shaded.client.com.leted request.
         *  It is not allowed to modify the same key several times within one txn.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.HashResponse> hash(alluxio.shaded.client.io.etcd.jetcd.api.HashRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Compact alluxio.shaded.client.com.acts the event history in the etcd key-value store. The key-value
         *  store should be periodically alluxio.shaded.client.com.acted or the event history will continue to grow
         *  indefinitely.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.HashKVResponse> hashKV(alluxio.shaded.client.io.etcd.jetcd.api.HashKVRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  MoveLeader requests current leader node to transfer its leadership to transferee.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.MoveLeaderResponse> moveLeader(alluxio.shaded.client.io.etcd.jetcd.api.MoveLeaderRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Snapshot sends a snapshot of the entire backend from a member over a stream to a client.
         * </pre>
         */
        public void snapshot(alluxio.shaded.client.io.etcd.jetcd.api.SnapshotRequest request, alluxio.shaded.client.io.vertx.core.streams.WriteStream<alluxio.shaded.client.io.etcd.jetcd.api.SnapshotResponse> response) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        @java.lang.Override public final alluxio.shaded.client.io.grpc.ServerServiceDefinition bindService() {
            return alluxio.shaded.client.io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.MaintenanceGrpc.getAlarmMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.AlarmRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.AlarmResponse>(
                                            this, METHODID_ALARM, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.MaintenanceGrpc.getStatusMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.StatusRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.StatusResponse>(
                                            this, METHODID_STATUS, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.MaintenanceGrpc.getDefragmentMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.DefragmentRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.DefragmentResponse>(
                                            this, METHODID_DEFRAGMENT, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.MaintenanceGrpc.getHashMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.HashRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.HashResponse>(
                                            this, METHODID_HASH, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.MaintenanceGrpc.getHashKVMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.HashKVRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.HashKVResponse>(
                                            this, METHODID_HASH_KV, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.MaintenanceGrpc.getSnapshotMethod(),
                            asyncServerStreamingCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.SnapshotRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.SnapshotResponse>(
                                            this, METHODID_SNAPSHOT, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.MaintenanceGrpc.getMoveLeaderMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.MoveLeaderRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.MoveLeaderResponse>(
                                            this, METHODID_MOVE_LEADER, alluxio.shaded.client.com.ression)))
                    .build();
        }
    }

    private static final int METHODID_ALARM = 0;
    private static final int METHODID_STATUS = 1;
    private static final int METHODID_DEFRAGMENT = 2;
    private static final int METHODID_HASH = 3;
    private static final int METHODID_HASH_KV = 4;
    private static final int METHODID_SNAPSHOT = 5;
    private static final int METHODID_MOVE_LEADER = 6;

    private static final class MethodHandlers<Req, Resp> implements
            alluxio.shaded.client.io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
            alluxio.shaded.client.io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
            alluxio.shaded.client.io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
            alluxio.shaded.client.io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {

        private final MaintenanceVertxImplBase serviceImpl;
        private final int methodId;
        private final String alluxio.shaded.client.com.ression;

        MethodHandlers(MaintenanceVertxImplBase serviceImpl, int methodId, String alluxio.shaded.client.com.ression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.alluxio.shaded.client.com.ression = alluxio.shaded.client.com.ression;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public void invoke(Req request, alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_ALARM:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.AlarmRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.AlarmResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::alarm);
                    break;
                case METHODID_STATUS:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.StatusRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.StatusResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::status);
                    break;
                case METHODID_DEFRAGMENT:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.DefragmentRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.DefragmentResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::defragment);
                    break;
                case METHODID_HASH:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.HashRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.HashResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::hash);
                    break;
                case METHODID_HASH_KV:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.HashKVRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.HashKVResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::hashKV);
                    break;
                case METHODID_SNAPSHOT:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToMany(
                            (alluxio.shaded.client.io.etcd.jetcd.api.SnapshotRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.SnapshotResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::snapshot);
                    break;
                case METHODID_MOVE_LEADER:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.MoveLeaderRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.MoveLeaderResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::moveLeader);
                    break;
                default:
                    throw new java.lang.AssertionError();
            }
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public alluxio.shaded.client.io.grpc.stub.StreamObserver<Req> invoke(alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                default:
                    throw new java.lang.AssertionError();
            }
        }
    }

}
