/*
 * Copyright (c) 2011-2019 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.alluxio.shaded.client.org.legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 */

package alluxio.shaded.client.io.vertx.core.eventbus.impl.codecs;

import alluxio.shaded.client.io.vertx.core.buffer.Buffer;
import alluxio.shaded.client.io.vertx.core.eventbus.MessageCodec;

/**
 * @author <a href="http://tfox.alluxio.shaded.client.org.>Tim Fox</a>
 */
public class ShortMessageCodec implements MessageCodec<Short, Short> {

  @Override
  public void encodeToWire(Buffer buffer, Short s) {
    buffer.appendShort(s);
  }

  @Override
  public Short decodeFromWire(int pos, Buffer buffer) {
    return buffer.getShort(pos);
  }

  @Override
  public Short transform(Short s) {
    // Shorts are immutable so just return it
    return s;
  }

  @Override
  public String name() {
    return "short";
  }

  @Override
  public byte systemCodecID() {
    return 4;
  }
}
