package alluxio.shaded.client.io.etcd.jetcd.api;

import static alluxio.shaded.client.io.etcd.jetcd.api.LeaseGrpc.getServiceDescriptor;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncBidiStreamingCall;


@alluxio.shaded.client.javax.annotation.Generated(
value = "by VertxGrpc generator",
alluxio.shaded.client.com.ents = "Source: rpc.proto")
public final class VertxLeaseGrpc {
    private VertxLeaseGrpc() {}

    public static LeaseVertxStub newVertxStub(alluxio.shaded.client.io.grpc.Channel channel) {
        return new LeaseVertxStub(channel);
    }

    
    public static final class LeaseVertxStub extends alluxio.shaded.client.io.grpc.stub.AbstractStub<LeaseVertxStub> {
        private final alluxio.shaded.client.io.vertx.core.impl.ContextInternal ctx;
        private LeaseGrpc.LeaseStub delegateStub;

        private LeaseVertxStub(alluxio.shaded.client.io.grpc.Channel channel) {
            super(channel);
            delegateStub = LeaseGrpc.newStub(channel);
            this.ctx = (alluxio.shaded.client.io.vertx.core.impl.ContextInternal) alluxio.shaded.client.io.vertx.core.Vertx.currentContext();
        }

        private LeaseVertxStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
            delegateStub = LeaseGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (alluxio.shaded.client.io.vertx.core.impl.ContextInternal) alluxio.shaded.client.io.vertx.core.Vertx.currentContext();
        }

        @Override
        protected LeaseVertxStub build(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
            return new LeaseVertxStub(channel, callOptions);
        }

        /**
         * <pre>
         *  Range gets the keys in the range from the key-value store.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.LeaseGrantResponse> leaseGrant(alluxio.shaded.client.io.etcd.jetcd.api.LeaseGrantRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::leaseGrant);
        }

        /**
         * <pre>
         *  Put puts the given key into the key-value store.
         *  A put request increments the revision of the key-value store
         *  and generates one event in the event history.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.LeaseRevokeResponse> leaseRevoke(alluxio.shaded.client.io.etcd.jetcd.api.LeaseRevokeRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::leaseRevoke);
        }

        /**
         * <pre>
         *  Txn processes multiple requests in a single transaction.
         *  A txn request increments the revision of the key-value store
         *  and generates events with the same revision for every alluxio.shaded.client.com.leted request.
         *  It is not allowed to modify the same key several times within one txn.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.LeaseTimeToLiveResponse> leaseTimeToLive(alluxio.shaded.client.io.etcd.jetcd.api.LeaseTimeToLiveRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::leaseTimeToLive);
        }

        /**
         * <pre>
         *  DeleteRange deletes the given range from the key-value store.
         *  A delete request increments the revision of the key-value store
         *  and generates a delete event in the event history for every deleted key.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.streams.ReadStream<alluxio.shaded.client.io.etcd.jetcd.api.LeaseKeepAliveResponse> leaseKeepAlive(alluxio.shaded.client.io.vertx.core.Handler<alluxio.shaded.client.io.vertx.core.streams.WriteStream<alluxio.shaded.client.io.etcd.jetcd.api.LeaseKeepAliveRequest>> hdlr) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.manyToMany(ctx, hdlr, delegateStub::leaseKeepAlive);
        }
    }

    
    public static abstract class LeaseVertxImplBase implements alluxio.shaded.client.io.grpc.BindableService {
        private String alluxio.shaded.client.com.ression;

        /**
         * Set whether the server will try to use a alluxio.shaded.client.com.ressed response.
         *
         * @param alluxio.shaded.client.com.ression the alluxio.shaded.client.com.ression, e.g {@code gzip}
         */
        public LeaseVertxImplBase withCompression(String alluxio.shaded.client.com.ression) {
            this.alluxio.shaded.client.com.ression = alluxio.shaded.client.com.ression;
            return this;
        }

        /**
         * <pre>
         *  Range gets the keys in the range from the key-value store.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.LeaseGrantResponse> leaseGrant(alluxio.shaded.client.io.etcd.jetcd.api.LeaseGrantRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Put puts the given key into the key-value store.
         *  A put request increments the revision of the key-value store
         *  and generates one event in the event history.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.LeaseRevokeResponse> leaseRevoke(alluxio.shaded.client.io.etcd.jetcd.api.LeaseRevokeRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Txn processes multiple requests in a single transaction.
         *  A txn request increments the revision of the key-value store
         *  and generates events with the same revision for every alluxio.shaded.client.com.leted request.
         *  It is not allowed to modify the same key several times within one txn.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.LeaseTimeToLiveResponse> leaseTimeToLive(alluxio.shaded.client.io.etcd.jetcd.api.LeaseTimeToLiveRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  DeleteRange deletes the given range from the key-value store.
         *  A delete request increments the revision of the key-value store
         *  and generates a delete event in the event history for every deleted key.
         * </pre>
         */
        public void leaseKeepAlive(alluxio.shaded.client.io.vertx.core.streams.ReadStream<alluxio.shaded.client.io.etcd.jetcd.api.LeaseKeepAliveRequest> request, alluxio.shaded.client.io.vertx.core.streams.WriteStream<alluxio.shaded.client.io.etcd.jetcd.api.LeaseKeepAliveResponse> response) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        @java.lang.Override public final alluxio.shaded.client.io.grpc.ServerServiceDefinition bindService() {
            return alluxio.shaded.client.io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.LeaseGrpc.getLeaseGrantMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.LeaseGrantRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.LeaseGrantResponse>(
                                            this, METHODID_LEASE_GRANT, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.LeaseGrpc.getLeaseRevokeMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.LeaseRevokeRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.LeaseRevokeResponse>(
                                            this, METHODID_LEASE_REVOKE, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.LeaseGrpc.getLeaseKeepAliveMethod(),
                            asyncBidiStreamingCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.LeaseKeepAliveRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.LeaseKeepAliveResponse>(
                                            this, METHODID_LEASE_KEEP_ALIVE, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.LeaseGrpc.getLeaseTimeToLiveMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.LeaseTimeToLiveRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.LeaseTimeToLiveResponse>(
                                            this, METHODID_LEASE_TIME_TO_LIVE, alluxio.shaded.client.com.ression)))
                    .build();
        }
    }

    private static final int METHODID_LEASE_GRANT = 0;
    private static final int METHODID_LEASE_REVOKE = 1;
    private static final int METHODID_LEASE_KEEP_ALIVE = 2;
    private static final int METHODID_LEASE_TIME_TO_LIVE = 3;

    private static final class MethodHandlers<Req, Resp> implements
            alluxio.shaded.client.io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
            alluxio.shaded.client.io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
            alluxio.shaded.client.io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
            alluxio.shaded.client.io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {

        private final LeaseVertxImplBase serviceImpl;
        private final int methodId;
        private final String alluxio.shaded.client.com.ression;

        MethodHandlers(LeaseVertxImplBase serviceImpl, int methodId, String alluxio.shaded.client.com.ression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.alluxio.shaded.client.com.ression = alluxio.shaded.client.com.ression;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public void invoke(Req request, alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_LEASE_GRANT:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.LeaseGrantRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.LeaseGrantResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::leaseGrant);
                    break;
                case METHODID_LEASE_REVOKE:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.LeaseRevokeRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.LeaseRevokeResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::leaseRevoke);
                    break;
                case METHODID_LEASE_TIME_TO_LIVE:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.LeaseTimeToLiveRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.LeaseTimeToLiveResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::leaseTimeToLive);
                    break;
                default:
                    throw new java.lang.AssertionError();
            }
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public alluxio.shaded.client.io.grpc.stub.StreamObserver<Req> invoke(alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_LEASE_KEEP_ALIVE:
                    return (alluxio.shaded.client.io.grpc.stub.StreamObserver<Req>) alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.manyToMany(
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.LeaseKeepAliveResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::leaseKeepAlive);
                default:
                    throw new java.lang.AssertionError();
            }
        }
    }

}
